/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.RenderAPI;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.util.ClientProxy;

public final class SnowClient {
    public static final SnowBlockEntity.Options fallbackOptions = new SnowBlockEntity.Options();
    public static final ResourceLocation OVERLAY_MODEL = new ResourceLocation("snowrealmagic", "block/overlay");
    public static final Map<ResourceLocation, ModelDefinition> snowVariantMapping = Maps.newLinkedHashMap();
    public static final Set<Block> overrideBlocks = Sets.newHashSet();
    public static BakedModel cachedSnowModel;
    public static BakedModel cachedOverlayModel;

    public static boolean renderHook(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState camo, SnowBlockEntity.Options options, @Nullable RenderType layer, Supplier<RandomSource> randomSupplier, boolean cullSides, RenderAPI api) {
        SnowVariant snowVariant;
        BlockState snow;
        BakedModel model;
        boolean full;
        Block block;
        if ((layer == null || layer == RenderType.m_110451_()) && (block = state.m_60734_()) instanceof WatcherSnowVariant) {
            WatcherSnowVariant watcher = (WatcherSnowVariant)block;
            watcher.updateOptions(state, (BlockGetter)world, pos, options);
        }
        boolean rendered = false;
        boolean useVariant = false;
        boolean bl = full = state.m_61138_((Property)SnowLayerBlock.f_56581_) && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) == 8;
        if (!full && !camo.m_60795_() && camo.m_60799_() == RenderShape.MODEL) {
            model = ClientProxy.getBlockModel(camo);
            if (SnowClientConfig.snowVariants && overrideBlocks.contains(camo.m_60734_())) {
                useVariant = true;
            }
            double yOffset = camo.m_204336_(CoreModule.OFFSET_Y) ? 0.101 : 0.0;
            rendered |= api.translateYAndRender(world, camo, pos, layer, randomSupplier, cullSides, model, yOffset);
        }
        if (!((snow = (snowVariant = (SnowVariant)state.m_60734_()).getSnowState(state, (BlockGetter)world, pos)).m_60795_() || layer != null && layer != RenderType.m_110451_())) {
            if (snow == Blocks.f_50125_.m_49966_()) {
                if (cachedSnowModel == null) {
                    cachedSnowModel = ClientProxy.getBlockModel(snow);
                }
                model = cachedSnowModel;
            } else {
                model = ClientProxy.getBlockModel(snow);
            }
            double yOffset = CoreModule.SLAB.is(state) ? 0.5 : 0.0;
            rendered |= api.translateYAndRender(world, snow, pos, layer, randomSupplier, cullSides, model, yOffset);
        }
        if (!(!options.renderOverlay || layer != null && layer != RenderType.m_110457_() || useVariant && !CoreModule.TILE_BLOCK.is(state))) {
            double yOffset;
            BlockPos pos2 = pos;
            if (CoreModule.TILE_BLOCK.is(state) || CoreModule.SLAB.is(state)) {
                if (cachedOverlayModel == null) {
                    cachedOverlayModel = ClientProxy.getBlockModel(OVERLAY_MODEL);
                }
                model = cachedOverlayModel;
                if (CoreModule.SLAB.is(state)) {
                    yOffset = -0.375;
                } else {
                    yOffset = -1.0;
                    pos2 = pos.m_7495_();
                }
            } else {
                yOffset = (float)snowVariant.getYOffset();
                model = ClientProxy.getBlockModel(state);
            }
            if (snowVariant.layers(state, (BlockGetter)world, pos) == 8) {
                yOffset -= 0.002;
            }
            rendered |= api.translateYAndRender(world, state, pos2, layer, randomSupplier, cullSides, model, yOffset);
        }
        return rendered;
    }
}

