/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowVariant;

public class ShapeCaches {
    public static final Cache<Key, VoxelShape> VISUAL = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<Key, VoxelShape> COLLIDER = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<Key, VoxelShape> OUTLINE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public static VoxelShape get(Cache<Key, VoxelShape> cache, BlockState state, BlockGetter level, BlockPos pos, Callable<? extends VoxelShape> loader) {
        try {
            Key key;
            SnowVariant snowVariant = (SnowVariant)state.m_60734_();
            int layers = snowVariant.layers(state, level, pos);
            if (CoreModule.TILE_BLOCK.is(state)) {
                BlockState raw = snowVariant.getRaw(state, level, pos);
                Class<?> clazz = raw.m_60734_().getClass();
                if (clazz != TallGrassBlock.class && clazz != TallFlowerBlock.class) {
                    return loader.call();
                }
                key = new Key(raw, layers);
            } else {
                key = new Key(state, layers);
            }
            return (VoxelShape)cache.get((Object)key, loader);
        }
        catch (Exception e) {
            SnowRealMagic.LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public record Key(BlockState state, int layers) {
    }
}

