/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_stitching;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.textures.StbStitcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Stitcher.class})
@ClientOnlyMixin
public class StitcherMixin<T extends Stitcher.Entry> {
    @Shadow
    @Final
    private List<Stitcher.Holder<T>> f_118163_;
    @Shadow
    private int f_118165_;
    @Shadow
    private int f_118166_;
    @Shadow
    @Final
    private int f_118167_;
    @Shadow
    @Final
    private int f_118168_;
    @Shadow
    @Final
    private static Comparator<Stitcher.Holder<?>> f_118161_;
    private List<StbStitcher.LoadableSpriteInfo<T>> loadableSpriteInfos;

    @Inject(method={"stitch"}, at={@At(value="HEAD")}, cancellable=true)
    private void stitchFast(CallbackInfo ci) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            ModernFix.LOGGER.error("Using vanilla stitcher implementation due to invalid loading state");
            return;
        }
        ci.cancel();
        ObjectArrayList holderList = new ObjectArrayList(this.f_118163_);
        holderList.sort(f_118161_);
        Stitcher.Holder[] aholder = (Stitcher.Holder[])holderList.toArray((Object[])new Stitcher.Holder[0]);
        Pair packingInfo = StbStitcher.packRects(aholder);
        this.f_118165_ = (Integer)((Pair)packingInfo.getFirst()).getFirst();
        this.f_118166_ = (Integer)((Pair)packingInfo.getFirst()).getSecond();
        if (this.f_118165_ > this.f_118167_ || this.f_118166_ > this.f_118168_) {
            ModernFix.LOGGER.error("Requested atlas size {}x{} exceeds maximum of {}x{}", (Object)this.f_118165_, (Object)this.f_118166_, (Object)this.f_118167_, (Object)this.f_118168_);
            throw new StitcherException(aholder[0].f_244486_(), (Collection)Stream.of(aholder).map(arg -> arg.f_244486_()).collect(ImmutableList.toImmutableList()));
        }
        this.loadableSpriteInfos = (List)packingInfo.getSecond();
    }

    @Inject(method={"gatherSprites"}, at={@At(value="HEAD")}, cancellable=true)
    private void gatherSpritesFast(Stitcher.SpriteLoader<T> spriteLoader, CallbackInfo ci) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            return;
        }
        ci.cancel();
        for (StbStitcher.LoadableSpriteInfo<T> info : this.loadableSpriteInfos) {
            spriteLoader.m_118228_(info.info, info.x, info.y);
        }
    }
}

