/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;

public interface ProgressCallback {
    public static final ProgressCallback TO_STD_OUT = new ProgressCallback(){
        private String currentStep;

        @Override
        public void message(String message, MessagePriority priority) {
            System.out.println(message);
        }

        @Override
        public String getCurrentStep() {
            return this.currentStep;
        }

        @Override
        public void setCurrentStep(String step) {
            this.message(step, MessagePriority.HIGH);
            this.currentStep = step;
        }
    };

    default public void start(String label) {
        this.message(label);
    }

    default public void stage(String message, boolean withProgress) {
        this.message(message);
    }

    default public void stage(String message) {
        this.stage(message, false);
    }

    default public void message(String message) {
        this.message(message, MessagePriority.NORMAL);
    }

    public void message(String var1, MessagePriority var2);

    public void setCurrentStep(String var1);

    public String getCurrentStep();

    default public ProgressBar getGlobalProgress() {
        return ProgressBar.NOOP;
    }

    default public ProgressBar getStepProgress() {
        return ProgressBar.NOOP;
    }

    default public InputStream wrapStepDownload(URLConnection connection) throws IOException {
        connection.connect();
        this.getStepProgress().setMaxProgress(connection.getContentLength());
        return this.wrapStepDownload(connection.getInputStream());
    }

    default public InputStream wrapStepDownload(InputStream in) {
        return new FilterInputStream(in){
            private int nread;
            {
                this.nread = 0;
            }

            @Override
            public int read() throws IOException {
                int c = this.in.read();
                if (c >= 0) {
                    ProgressCallback.this.getStepProgress().progress(++this.nread);
                }
                return c;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int nr = this.in.read(b);
                if (nr > 0) {
                    ProgressCallback.this.getStepProgress().progress(this.nread += nr);
                }
                return nr;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int nr = this.in.read(b, off, len);
                if (nr > 0) {
                    ProgressCallback.this.getStepProgress().progress(this.nread += nr);
                }
                return nr;
            }

            @Override
            public long skip(long n) throws IOException {
                long nr = this.in.skip(n);
                if (nr > 0L) {
                    this.nread = (int)((long)this.nread + nr);
                    ProgressCallback.this.getStepProgress().progress(this.nread);
                }
                return nr;
            }
        };
    }

    public static ProgressCallback withOutputs(final OutputStream ... streams) {
        return new ProgressCallback(){
            private String step;

            @Override
            public void message(String message, MessagePriority priority) {
                message = message + System.lineSeparator();
                for (OutputStream out : streams) {
                    try {
                        out.write(message.getBytes());
                        out.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void setCurrentStep(String step) {
                this.message(step, MessagePriority.HIGH);
                this.step = step;
            }

            @Override
            public String getCurrentStep() {
                return this.step;
            }
        };
    }

    default public ProgressCallback withoutDownloadProgress() {
        final ProgressCallback self = this;
        return new ProgressCallback(){

            @Override
            public void start(String label) {
                self.start(label);
            }

            @Override
            public void stage(String message, boolean withProgress) {
                self.stage(message, withProgress);
            }

            @Override
            public void stage(String message) {
                self.stage(message);
            }

            @Override
            public void message(String message) {
                self.message(message);
            }

            @Override
            public ProgressBar getGlobalProgress() {
                return self.getGlobalProgress();
            }

            @Override
            public ProgressBar getStepProgress() {
                return self.getStepProgress();
            }

            @Override
            public InputStream wrapStepDownload(URLConnection connection) throws IOException {
                return connection.getInputStream();
            }

            @Override
            public InputStream wrapStepDownload(InputStream in) {
                return in;
            }

            @Override
            public void message(String message, MessagePriority priority) {
                self.message(message, priority);
            }

            @Override
            public void setCurrentStep(String step) {
                self.setCurrentStep(step);
            }

            @Override
            public String getCurrentStep() {
                return self.getCurrentStep();
            }
        };
    }

    public static interface ProgressBar {
        public static final ProgressBar NOOP = new ProgressBar(){

            @Override
            public void setMaxProgress(int maximum) {
            }

            @Override
            public void progress(int value) {
            }

            @Override
            public void percentageProgress(double value) {
            }

            @Override
            public void setIndeterminate(boolean indeterminate) {
            }
        };

        public void setMaxProgress(int var1);

        public void progress(int var1);

        public void percentageProgress(double var1);

        public void setIndeterminate(boolean var1);
    }

    public static enum MessagePriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

