/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.function.Predicate;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.TargetValidator;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.ui.TranslatedMessage;

public class ExtractAction
extends Action {
    public ExtractAction(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, true);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals, File Installer) {
        File file;
        boolean result = true;
        String failed = "An error occurred extracting the files:";
        Artifact contained = this.profile.getPath();
        if (contained != null && !DownloadUtils.extractFile(contained, file = new File(target, contained.getFilename()), null)) {
            result = false;
            failed = failed + "\n" + contained.getFilename();
        }
        if (!result) {
            this.error(failed);
        }
        return result;
    }

    @Override
    public TargetValidator getTargetValidator() {
        return TargetValidator.shouldExist(true).and(TargetValidator.isDirectory());
    }

    @Override
    public TranslatedMessage getSuccessMessage() {
        return new TranslatedMessage("installer.action.extract.finished", new Object[0]);
    }
}

