/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.FixSSL;
import net.minecraftforge.installer.actions.Actions;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.ui.InstallerPanel;
import net.neoforged.cliutils.progress.ProgressInterceptor;
import net.neoforged.cliutils.progress.ProgressManager;

public class SimpleInstaller {
    public static boolean headless = false;
    public static boolean debug = false;
    public static URL mirror = null;

    public static void main(String[] args) throws IOException, URISyntaxException {
        ProgressCallback monitor;
        try {
            monitor = ProgressCallback.withOutputs(System.out, SimpleInstaller.getLog());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            monitor = ProgressCallback.withOutputs(System.out);
        }
        SimpleInstaller.hookStdOut(monitor);
        if (System.getProperty("java.net.preferIPv4Stack") == null) {
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        String vendor = System.getProperty("java.vendor", "missing vendor");
        String javaVersion = System.getProperty("java.version", "missing java version");
        String jvmVersion = System.getProperty("java.vm.version", "missing jvm version");
        monitor.message(String.format("JVM info: %s - %s - %s", vendor, javaVersion, jvmVersion));
        monitor.message("java.net.preferIPv4Stack=" + System.getProperty("java.net.preferIPv4Stack"));
        monitor.message("Current Time: " + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()));
        File installer = new File(SimpleInstaller.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (installer.getAbsolutePath().contains("!/")) {
            monitor.stage("Due to java limitation, please do not run this jar in a folder ending with !");
            monitor.message(installer.getAbsolutePath());
            return;
        }
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> clientInstallOption = parser.acceptsAll(Arrays.asList("installClient", "install-client"), "Install a client to the specified directory, defaulting to the MC installation directory").withOptionalArg().ofType(File.class).defaultsTo(SimpleInstaller.getMCDir(), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> serverInstallOption = parser.acceptsAll(Arrays.asList("installServer", "install-server"), "Install a server to the current directory").withOptionalArg().ofType(File.class).defaultsTo(new File("."), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> extractOption = parser.accepts("extract", "Extract the contained jar file to the specified directory").withOptionalArg().ofType(File.class).defaultsTo(new File("."), (File[])new File[0]);
        OptionSpecBuilder helpOption = parser.acceptsAll(Arrays.asList("h", "help"), "Help with this installer");
        OptionSpecBuilder offlineOption = parser.accepts("offline", "Don't attempt any network calls");
        OptionSpecBuilder debugOption = parser.accepts("debug", "Run in debug mode -- don't delete any files");
        ArgumentAcceptingOptionSpec<URL> mirrorOption = parser.accepts("mirror", "Use a specific mirror URL").withRequiredArg().ofType(URL.class);
        OptionSet optionSet = parser.parse(args);
        if (optionSet.has(helpOption)) {
            parser.printHelpOn(System.out);
            return;
        }
        debug = optionSet.has(debugOption);
        if (optionSet.has(mirrorOption)) {
            mirror = optionSet.valueOf(mirrorOption);
        }
        if (optionSet.has(offlineOption)) {
            DownloadUtils.OFFLINE_MODE = true;
            monitor.message("ENABLING OFFLINE MODE");
        } else {
            for (String host : new String[]{"maven.neoforged.net", "libraries.minecraft.net", "launchermeta.mojang.com", "piston-meta.mojang.com", "sessionserver.mojang.com"}) {
                monitor.message("Host: " + host + " [" + DownloadUtils.getIps(host).stream().collect(Collectors.joining(", ")) + "]");
            }
            FixSSL.fixup(monitor);
        }
        Actions action = null;
        File target = null;
        if (optionSet.has(serverInstallOption)) {
            action = Actions.SERVER;
            target = optionSet.valueOf(serverInstallOption);
        } else if (optionSet.has(extractOption)) {
            action = Actions.EXTRACT;
            target = optionSet.valueOf(extractOption);
        } else if (optionSet.has(clientInstallOption)) {
            action = Actions.CLIENT;
            target = optionSet.valueOf(clientInstallOption);
        }
        if (action != null) {
            try {
                headless = true;
                monitor.message("Target Directory: " + target);
                InstallV1 install = Util.loadInstallProfile();
                if (!action.getAction(install, monitor).run(target, a -> true, installer)) {
                    monitor.stage("There was an error during installation");
                    System.exit(1);
                } else {
                    monitor.message(action.getSuccess());
                    monitor.stage("You can delete this installer file now if you wish");
                }
                System.exit(0);
            }
            catch (Throwable e) {
                monitor.stage("A problem installing was detected, install cannot continue");
                System.exit(1);
            }
        } else {
            SimpleInstaller.launchGui(monitor, installer);
        }
    }

    public static File getMCDir() {
        String userHomeDir = System.getProperty("user.home", ".");
        String osType = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String mcDir = ".minecraft";
        if (osType.contains("win") && System.getenv("APPDATA") != null) {
            return new File(System.getenv("APPDATA"), mcDir);
        }
        if (osType.contains("mac")) {
            return new File(new File(new File(userHomeDir, "Library"), "Application Support"), "minecraft");
        }
        return new File(userHomeDir, mcDir);
    }

    private static void launchGui(ProgressCallback monitor, File installer) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            InstallV1 profile = Util.loadInstallProfile();
            InstallerPanel panel = new InstallerPanel(SimpleInstaller.getMCDir(), profile, installer);
            panel.run(monitor);
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, "Something went wrong while installing.<br />Check log for more details:<br/>" + e.toString(), "Error", 0);
        }
    }

    private static OutputStream getLog() throws FileNotFoundException {
        File f = new File(SimpleInstaller.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        File output = f.isFile() ? new File(f.getName() + ".log") : new File("installer.log");
        System.out.println("Outputting log to file " + output);
        return new BufferedOutputStream(new FileOutputStream(output));
    }

    public static void hookStdOut(final ProgressCallback monitor) {
        final Pattern endingWhitespace = Pattern.compile("\\r?\\n$");
        OutputStream monitorStream = new OutputStream(){
            private StringBuffer buffer = new StringBuffer();

            @Override
            public void write(byte[] buf, int off, int len) {
                for (int i = off; i < off + len; ++i) {
                    this.write(buf[i]);
                }
            }

            @Override
            public void write(byte[] b) {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(int b) {
                if (b == 13) {
                    return;
                }
                if (b == 10) {
                    String message = endingWhitespace.matcher(this.buffer.toString()).replaceAll("");
                    if (!message.isEmpty()) {
                        monitor.message(message);
                    }
                    this.buffer = new StringBuffer();
                } else {
                    this.buffer.append((char)b);
                }
            }
        };
        System.setOut(new PrintStream(monitorStream));
        System.setErr(new PrintStream(new ProgressInterceptor(monitorStream, new ProgressManager(){

            @Override
            public void setMaxProgress(int maxProgress) {
                monitor.getStepProgress().setMaxProgress(maxProgress);
            }

            @Override
            public void setProgress(int progress) {
                monitor.getStepProgress().progress(progress);
            }

            @Override
            public void setPercentageProgress(double percentage) {
                monitor.getStepProgress().percentageProgress(percentage);
            }

            @Override
            public void setStep(String step) {
                monitor.message(monitor.getCurrentStep() + ": " + step, ProgressCallback.MessagePriority.HIGH);
            }

            @Override
            public void setIndeterminate(boolean indeterminate) {
                monitor.getStepProgress().setIndeterminate(false);
            }
        })));
        System.setProperty("net.neoforged.progressmanager.enabled", "true");
    }
}

