/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.network.PacketReturnInventoryInfo;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetInventoryInfo {
    private final ResourceKey<Level> id;
    private final BlockPos pos;
    private final boolean doscan;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.id.m_135782_());
        buf.writeBoolean(this.doscan);
    }

    public PacketGetInventoryInfo(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.id = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.doscan = buf.readBoolean();
    }

    public PacketGetInventoryInfo(ResourceKey<Level> worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> this.onMessageServer((Player)ctx.getSender()).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, ctx.getSender())));
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, ServerPlayer player) {
        PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
        RFToolsStorageMessages.INSTANCE.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(Player player) {
        ServerLevel world = LevelTools.getLevel((Level)player.m_9236_(), this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        BlockEntity te = world.m_7702_(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scanner.findInventories() : scanner.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$2((Level)world, scanner, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(Level world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!LevelTools.isLoaded((Level)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
            block = null;
        } else if (world.m_46859_(pos)) {
            displayName = "[REMOVED]";
            block = null;
        } else {
            displayName = Tools.getReadableName((Level)world, (BlockPos)pos);
            BlockEntity storageTe = world.m_7702_(pos);
            if (storageTe instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)storageTe;
                String finalDisplayName = displayName;
                displayName = storage.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> {
                    ItemStack storageModule = h.getStackInSlot(0);
                    if (!storageModule.m_41619_() && storageModule.m_41782_() && storageModule.m_41783_().m_128441_("display")) {
                        return storageModule.m_41786_().getString();
                    }
                    return finalDisplayName;
                }).orElse(displayName);
            }
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), block);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$2(Level world, StorageScannerTileEntity scanner, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scanner);
    }
}

