/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.network;

import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketStorageInfoToClient {
    private final BlockPos pos;
    private final String viewMode;
    private final String sortMode;
    private final boolean groupMode;
    private final String filter;
    private final boolean locked;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.viewMode);
        buf.m_130070_(this.sortMode);
        buf.writeBoolean(this.groupMode);
        buf.m_130070_(this.filter);
        buf.writeBoolean(this.locked);
    }

    public PacketStorageInfoToClient(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.viewMode = buf.m_130136_(Short.MAX_VALUE);
        this.sortMode = buf.m_130136_(Short.MAX_VALUE);
        this.groupMode = buf.readBoolean();
        this.filter = buf.m_130136_(Short.MAX_VALUE);
        this.locked = buf.readBoolean();
    }

    public PacketStorageInfoToClient(BlockPos pos, String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.pos = pos;
        this.locked = locked;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (te instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
                storage.syncInventoryFromServer(this.sortMode, this.viewMode, this.groupMode, this.filter, this.locked);
            }
        });
        ctx.setPacketHandled(true);
    }
}

