/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod.item;

import com.ldtteam.blockui.util.SingleBlockGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BlockToItemHelper {
    public static final HitResult CLONE_ITEM_STACK_HIT_RESULT = new BlockHitResult(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), Direction.DOWN, BlockPos.f_121853_, false);

    public static ItemStack getItemStack(BlockState blockState, BlockEntity blockEntity, Player player) {
        if (blockState.m_60734_() instanceof AirBlock) {
            return ItemStack.f_41583_;
        }
        ItemStack result = BlockToItemHelper.getItemStackUsingPlayerPick(blockState, blockEntity, player);
        return result.m_41619_() ? BlockToItemHelper.getItem(blockState).m_7968_() : result;
    }

    public static ItemStack getItemStack(BlockState blockState, BlockEntity blockEntity, ServerLevel serverLevel) {
        return BlockToItemHelper.getItemStack(blockState, blockEntity, (Player)FakePlayerFactory.getMinecraft((ServerLevel)serverLevel));
    }

    public static ItemStack getItemStackUsingPlayerPick(BlockState blockState, BlockEntity blockEntity, Player player) {
        return blockState.getCloneItemStack(CLONE_ITEM_STACK_HIT_RESULT, (BlockGetter)new SingleBlockGetter(blockState, blockEntity), BlockPos.f_121853_, player);
    }

    private static Item getItem(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            return liquid.getFluid().m_6859_();
        }
        if (block instanceof BubbleColumnBlock) {
            BubbleColumnBlock column = (BubbleColumnBlock)block;
            return column.m_5888_(blockState).m_76152_().m_6859_();
        }
        if (block instanceof BaseFireBlock) {
            return Items.f_42409_;
        }
        return block.m_5456_();
    }
}

