/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class TerminalStorageState {
    public static final String SETTING_TAB = "tab";
    public static final String SETTING_SEARCH = "search";
    public static final String SETTING_BUTTON = "button";
    public static final String PLAYER_TAG_DEFAULT_KEY = "integratedterminals:terminalStorageStateDefault";
    private CompoundTag tag;
    private IDirtyMarkListener dirtyMarkListener;

    public TerminalStorageState(IDirtyMarkListener dirtyMarkListener) {
        this(new CompoundTag(), dirtyMarkListener);
    }

    public TerminalStorageState(CompoundTag tag, IDirtyMarkListener dirtyMarkListener) {
        this.tag = tag;
        this.dirtyMarkListener = dirtyMarkListener;
    }

    public void setDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListener = dirtyMarkListener;
    }

    protected void markDirty() {
        this.dirtyMarkListener.onDirty();
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
        this.markDirty();
    }

    public String getTab() {
        return this.tag.m_128461_(SETTING_TAB);
    }

    public boolean hasTab() {
        return this.tag.m_128425_(SETTING_TAB, 8);
    }

    public void setTab(@Nullable String tab) {
        if (tab != null) {
            this.tag.m_128359_(SETTING_TAB, tab);
        } else {
            this.tag.m_128473_(SETTING_TAB);
        }
        this.markDirty();
    }

    public String getSearch(String tab, int channel) {
        return this.tag.m_128461_("search_" + tab + "_" + channel);
    }

    public boolean hasSearch(String tab, int channel) {
        return this.tag.m_128425_("search_" + tab + "_" + channel, 8);
    }

    public void setSearch(String tab, int channel, @Nullable String search) {
        if (tab != null) {
            this.tag.m_128359_("search_" + tab + "_" + channel, search);
        } else {
            this.tag.m_128473_("search_" + tab + "_" + channel);
        }
        this.markDirty();
    }

    public Tag getButton(String tab, String buttonName) {
        return this.tag.m_128423_("button_" + tab + "_" + buttonName);
    }

    public boolean hasButton(String tab, String buttonName) {
        return this.tag.m_128441_("button_" + tab + "_" + buttonName);
    }

    public void setButton(String tab, String buttonName, @Nullable Tag button) {
        if (button != null) {
            this.tag.m_128365_("button_" + tab + "_" + buttonName, button);
        } else {
            this.tag.m_128473_(SETTING_TAB);
        }
        this.markDirty();
    }

    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.tag);
    }

    public static TerminalStorageState readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        return new TerminalStorageState(packetBuffer.m_130260_(), () -> {});
    }

    public static void setPlayerDefault(Player playerEntity, TerminalStorageState state) {
        playerEntity.getPersistentData().m_128365_(PLAYER_TAG_DEFAULT_KEY, (Tag)state.getTag().m_6426_());
    }

    public static TerminalStorageState getPlayerDefault(Player playerEntity, IDirtyMarkListener dirtyMarkListener) {
        if (playerEntity.getPersistentData().m_128441_(PLAYER_TAG_DEFAULT_KEY)) {
            return new TerminalStorageState(playerEntity.getPersistentData().m_128469_(PLAYER_TAG_DEFAULT_KEY), dirtyMarkListener);
        }
        return new TerminalStorageState(dirtyMarkListener);
    }
}

