/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.Utils;
import com.tagnumelite.projecteintegration.api.recipe.IRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public abstract class ABaseRecipeMapper<R>
implements IRecipeMapper<R> {
    protected ResourceLocation recipeID;
    protected IMappingCollector<NormalizedSimpleStack, Long> mapper;
    protected INSSFakeGroupManager fakeGroupManager;
    protected RegistryAccess registryAccess;

    @Override
    public String getDescription() {
        return "ProjectE-Integration Recipe Mapper for " + this.getName().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2") + ". Required Mods: [" + String.join((CharSequence)",", this.getRequiredMods()) + "]";
    }

    @Override
    public boolean convertRecipe(R recipe) {
        NSSOutput output = this.getOutput(recipe);
        if (output == null || output.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no outputs: {}", this.recipeID, output);
            return false;
        }
        NSSInput input = this.getInput(recipe);
        if (input == null || !input.successful) {
            return this.addConversionsAndReturn(input != null ? input.fakeGroupMap : null, true);
        }
        this.mapper.addConversion(output.amount, (Object)output.nss, input.getMap());
        return this.addConversionsAndReturn(input.fakeGroupMap, true);
    }

    protected NSSInput convertFluidIngredients(List<List<FluidStack>> fluidIngredients) {
        if (fluidIngredients == null || fluidIngredients.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no inputs: {}", this.recipeID, fluidIngredients);
            return null;
        }
        ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
        IngredientMap ingredientMap = new IngredientMap();
        for (List<FluidStack> ingredient : fluidIngredients) {
            if (this.convertFluidIngredient(ingredient, (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
        }
        return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
    }

    protected boolean convertFluidIngredient(List<FluidStack> fluidIngredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return this.convertFluidIngredient(-1, fluidIngredient, ingredientMap, fakeGroupMap);
    }

    protected boolean convertFluidIngredient(int amount, List<FluidStack> fluidIngredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return Utils.convertFluidIngredient(amount, fluidIngredient, ingredientMap, fakeGroupMap, this.fakeGroupManager, this.recipeID.toString());
    }

    protected boolean convertIngredient(Ingredient ingredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return this.convertIngredient(-1, ingredient, ingredientMap, fakeGroupMap);
    }

    protected boolean convertIngredient(int amount, Ingredient ingredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return Utils.convertIngredient(amount, ingredient, ingredientMap, fakeGroupMap, this.fakeGroupManager, this.recipeID.toString());
    }

    protected NSSOutput mapOutputs(Object ... allOutputs) {
        return Utils.mapOutputs(this.mapper, this.fakeGroupManager, this.recipeID.toString(), allOutputs);
    }

    protected NSSOutput mapOutput(Object ... outputVariants) {
        return Utils.mapOutput(this.mapper, this.fakeGroupManager, this.recipeID.toString(), outputVariants);
    }

    protected boolean addIngredient(IngredientMap<NormalizedSimpleStack> ingredientMap, FluidStack stack) {
        return Utils.addIngredient(ingredientMap, stack);
    }

    protected boolean addConversionsAndReturn(List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> dummyGroupInfos, boolean returnValue) {
        if (dummyGroupInfos != null) {
            for (Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>> dummyGroupInfo : dummyGroupInfos) {
                for (IngredientMap groupIngredientMap : (List)dummyGroupInfo.m_14419_()) {
                    this.mapper.addConversion(1, (Object)((NormalizedSimpleStack)dummyGroupInfo.m_14418_()), groupIngredientMap.getMap());
                }
            }
        }
        return returnValue;
    }

    protected Tuple<NormalizedSimpleStack, Boolean> getFakeGroup(NormalizedSimpleStack ... stacks) {
        return this.fakeGroupManager.getOrCreateFakeGroup(new HashSet<NormalizedSimpleStack>(Arrays.asList(stacks)));
    }

    public NSSOutput.Builder getOutputBuilder() {
        return new NSSOutput.Builder(this.mapper, this.fakeGroupManager, this.recipeID);
    }

    public abstract String[] getRequiredMods();
}

