/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class PneumaticCraftAddon {
    public static final String MODID = "pneumaticcraft";

    static String NAME(String name) {
        return "PneumaticCraft" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRThermoPlantMapper
    extends PCRMapper<ThermoPlantRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("ThermopneumaticProcessingPlant");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.THERMO_PLANT.get();
        }

        @Override
        public NSSOutput getOutput(ThermoPlantRecipe recipe) {
            boolean fluidEmpty;
            ItemStack outputItem = recipe.getOutputItem();
            FluidStack outputFluid = recipe.getOutputFluid();
            boolean itemEmpty = outputItem == null || outputItem.m_41619_();
            boolean bl = fluidEmpty = outputFluid == null || outputFluid.isEmpty();
            if (itemEmpty && fluidEmpty) {
                return NSSOutput.EMPTY;
            }
            if (!itemEmpty && fluidEmpty) {
                return new NSSOutput(outputItem);
            }
            if (itemEmpty) {
                return new NSSOutput(outputFluid);
            }
            return this.mapOutputs(outputItem, outputFluid);
        }

        @Override
        protected List<Ingredient> getIngredients(ThermoPlantRecipe recipe) {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            if (recipe.getInputItem() != null && !recipe.getInputItem().m_43947_()) {
                inputs.add(recipe.getInputItem());
            }
            if (recipe.getInputFluid() != null && !recipe.getInputFluid().m_43947_()) {
                inputs.add((Ingredient)recipe.getInputFluid());
            }
            return inputs;
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRRefineryMapper
    extends PCRMapper<RefineryRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("Refinery");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.REFINERY.get();
        }

        @Override
        public NSSOutput getOutput(RefineryRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRPressureChamberMapper
    extends ARecipeTypeMapper<PressureChamberRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("PressureChamber");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.PRESSURE_CHAMBER.get();
        }

        @Override
        protected List<Ingredient> getIngredients(PressureChamberRecipe recipe) {
            return recipe.getInputsForDisplay();
        }

        @Override
        public NSSOutput getOutput(PressureChamberRecipe recipe) {
            return this.mapOutputs(recipe.getResultsForDisplay().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRHeatFrameCoolingMapper
    extends PCRMapper<HeatFrameCoolingRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("HeatFrameCooling");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.HEAT_FRAME_COOLING.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRExplosionCraftingMapper
    extends ARecipeTypeMapper<ExplosionCraftingRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("ExplosionCrafting");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default because this mapper ignore loss rate.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.EXPLOSION_CRAFTING.get();
        }

        @Override
        protected List<Ingredient> getIngredients(ExplosionCraftingRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(ExplosionCraftingRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRAssemblyMapper
    extends ARecipeTypeMapper<AssemblyRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("Assembly");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.ASSEMBLY_DRILL.get() || recipeType == ModRecipeTypes.ASSEMBLY_LASER.get() || recipeType == ModRecipeTypes.ASSEMBLY_DRILL_LASER.get();
        }

        @Override
        public NSSInput getInput(AssemblyRecipe recipe) {
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            this.convertIngredient(recipe.getInputAmount(), recipe.getInput(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(AssemblyRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRAmadronOfferMapper
    extends ARecipeTypeMapper<AmadronOffer> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("AmadronOffer");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.AMADRON.get();
        }
    }

    public static abstract class PCRMapper<R extends PneumaticCraftRecipe>
    extends ARecipeTypeMapper<R> {
        @Override
        protected boolean convertIngredient(Ingredient ingredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
            if (ingredient instanceof FluidIngredient) {
                return this.convertFluidIngredient((FluidIngredient)ingredient, ingredientMap, fakeGroupMap);
            }
            return super.convertIngredient(ingredient, ingredientMap, fakeGroupMap);
        }

        protected boolean convertFluidIngredient(FluidIngredient ingredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap) {
            List matches = ingredient.getFluidStacks();
            if (matches == null) {
                return false;
            }
            if (matches.size() == 1) {
                return !this.addIngredient(ingredientMap, (FluidStack)matches.get(0));
            }
            if (matches.size() > 0) {
                HashSet<NSSFluid> rawNSSMatches = new HashSet<NSSFluid>();
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (FluidStack match : matches) {
                    if (match.isEmpty()) continue;
                    rawNSSMatches.add(NSSFluid.createFluid((FluidStack)match));
                    stacks.add(match);
                }
                int count = stacks.size();
                if (count == 1) {
                    return !this.addIngredient(ingredientMap, (FluidStack)stacks.get(0));
                }
                if (count > 1) {
                    Tuple group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                    NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.m_14418_();
                    ingredientMap.addIngredient((Object)dummy, Math.max(ingredient.getAmount(), 1));
                    if (((Boolean)group.m_14419_()).booleanValue()) {
                        ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                        Iterator iterator = stacks.iterator();
                        while (iterator.hasNext()) {
                            IngredientMap groupIngredientMap = new IngredientMap();
                            FluidStack stack = (FluidStack)iterator.next();
                            if (this.addIngredient((IngredientMap<NormalizedSimpleStack>)groupIngredientMap, stack.copy())) {
                                return false;
                            }
                            groupIngredientMaps.add(groupIngredientMap);
                        }
                        fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                    }
                }
            }
            return true;
        }
    }
}

