/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class EvilCraftAddon {
    public static final String MODID = "evilcraft";

    public static String NAME(String name) {
        return "EvilCraft" + name + "Mapper";
    }

    @ConversionProvider(value="evilcraft")
    public static class ECConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for EvilCraft").before(RegistryEntries.FLUID_BLOOD.m_5613_(), 1L).before(RegistryEntries.FLUID_BLOOD.m_5615_(), 1L);
        }
    }

    @RecipeTypeMapper(requiredMods={"evilcraft"}, priority=1)
    public static class ECEnvironmentalAccumulatorMapper
    extends ARecipeTypeMapper<RecipeEnvironmentalAccumulator> {
        @Override
        public String getName() {
            return EvilCraftAddon.NAME("EnvironmentalAccumulator");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR;
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeEnvironmentalAccumulator recipe) {
            return Collections.singletonList(recipe.getInputIngredient());
        }
    }

    @RecipeTypeMapper(requiredMods={"evilcraft"}, priority=1)
    public static class ECBloodInfuserMapper
    extends ARecipeTypeMapper<RecipeBloodInfuser> {
        @Override
        public String getName() {
            return EvilCraftAddon.NAME("BloodInfuser");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
        }

        @Override
        public NSSInput getInput(RecipeBloodInfuser recipe) {
            IngredientMap ingMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            this.convertIngredient(recipe.getInputIngredient(), (IngredientMap<NormalizedSimpleStack>)ingMap, fakeGroupMap);
            ingMap.addIngredient((Object)NSSFluid.createFluid((Fluid)recipe.getInputFluid().getFluid()), recipe.getInputFluid().getAmount());
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingMap, fakeGroupMap, true);
        }
    }
}

