/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.volcano;

public enum VolcanoState {
    DORMANT(604800),
    SMOKING(600),
    RISING(3000),
    ERUPTING(3000),
    RETREATING(600);

    private final int duration;

    private VolcanoState(int duration) {
        this.duration = duration;
    }

    public static int getTimeBefore(VolcanoState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case DORMANT -> VolcanoState.RETREATING.duration;
            case SMOKING -> VolcanoState.DORMANT.duration;
            case RISING -> VolcanoState.SMOKING.duration;
            case ERUPTING -> VolcanoState.RISING.duration;
            case RETREATING -> VolcanoState.ERUPTING.duration;
        };
    }
}

