/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class FurnitureEntity
extends Entity {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.m_135353_(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GLUED_DOWN = SynchedEntityData.m_135353_(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int DAMAGE_THRESHOLD = 40;
    private final Function<DyeColor, Item> itemLookup;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYaw = Double.NaN;
    protected double lerpPitch;

    protected FurnitureEntity(EntityType<?> entityTypeIn, Level worldIn, Map<DyeColor, ? extends RegistryEntry<? extends Item>> items) {
        this(entityTypeIn, worldIn, (DyeColor c) -> (Item)((RegistryEntry)items.get(c)).get());
    }

    protected FurnitureEntity(EntityType<?> entityTypeIn, Level worldIn, Function<DyeColor, Item> itemLookup) {
        super(entityTypeIn, worldIn);
        this.itemLookup = itemLookup;
        this.f_19850_ = true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return (Boolean)this.f_19804_.m_135370_(GLUED_DOWN) != false || super.m_6673_(pSource);
    }

    public void setRotation(float yaw) {
        this.lerpYaw = Mth.m_14177_((float)yaw);
        this.m_146922_((float)this.lerpYaw);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(COLOR, (Object)0);
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(FORWARD_DIRECTION, (Object)1);
        this.m_20088_().m_135372_(TIME_SINCE_HIT, (Object)0);
        this.m_20088_().m_135372_(GLUED_DOWN, (Object)false);
    }

    public void m_8119_() {
        float damage;
        int timeSinceHit = this.getTimeSinceHit();
        if (timeSinceHit > 0) {
            this.setTimeSinceHit(timeSinceHit - 1);
        }
        if ((damage = this.getDamage()) > 0.0f) {
            this.setDamage(damage - 1.0f);
        }
        Vec3 currentPos = this.m_20182_();
        this.f_19854_ = currentPos.f_82479_;
        this.f_19855_ = currentPos.f_82480_;
        this.f_19856_ = currentPos.f_82481_;
        super.m_8119_();
        this.tickLerp();
        if (this.preventMotion()) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20101_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                this.m_7334_(entity);
            }
        }
    }

    protected boolean preventMotion() {
        return true;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (teleport) {
            super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        } else {
            this.lerpX = x;
            this.lerpY = y;
            this.lerpZ = z;
            if (yaw != this.m_146908_() || Double.isNaN(this.lerpYaw)) {
                this.lerpYaw = Mth.m_14175_((double)yaw);
            }
            this.lerpSteps = 10;
            this.m_146926_(pitch);
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.lerpSteps));
            this.m_146926_((float)((double)this.m_146909_() + (this.lerpPitch - (double)this.m_146909_()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (this.invulnerablityCheck(pPlayer, pHand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public InteractionResult invulnerablityCheck(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_21120_(pHand).m_150930_(Items.f_42751_)) {
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(GLUED_DOWN, (Object)((Boolean)this.f_19804_.m_135370_(GLUED_DOWN) == false ? 1 : 0));
                pPlayer.m_213846_((Component)Component.m_237115_((String)("Invulnerability Mode: " + ((Boolean)this.f_19804_.m_135370_(GLUED_DOWN) != false ? "On" : "Off"))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            Entity entity = damageSource.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return player.m_21205_().m_150930_(Items.f_42751_);
            }
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.m_5834_();
            boolean bl = flag = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                LivingEntity rider = this.m_6688_();
                if (rider != null) {
                    rider.m_20329_((Entity)this);
                }
                if (!flag) {
                    this.m_5552_(this.getItemStack(), 0.0f);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        return true;
    }

    private ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.itemLookup.apply(this.getColor()));
    }

    public double m_6048_() {
        return 0.0;
    }

    public void m_6053_(float direction) {
        this.setForwardDirection(-1 * this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamage(this.getDamage() * 10.0f);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7378_(CompoundTag nbt) {
        this.setColor(DyeColor.m_41053_((int)nbt.m_128451_("Color")));
        if (nbt.m_128441_("GluedDown")) {
            this.f_19804_.m_135381_(GLUED_DOWN, (Object)nbt.m_128471_("GluedDown"));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Color", this.getColor().ordinal());
        nbt.m_128379_("GluedDown", ((Boolean)this.f_19804_.m_135370_(GLUED_DOWN)).booleanValue());
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(COLOR, (Object)color.ordinal());
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(COLOR)));
    }

    public void setForwardDirection(int dir) {
        this.f_19804_.m_135381_(FORWARD_DIRECTION, (Object)dir);
    }

    public int getForwardDirection() {
        return (Integer)this.f_19804_.m_135370_(FORWARD_DIRECTION);
    }

    public void setDamage(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }
}

