/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import com.google.common.collect.AbstractIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class WaterWalking {
    private static final double HEIGHT = 0.875;
    public static final VoxelShape COLLIDER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public static boolean canWalkOn(FluidState fluid) {
        return !fluid.m_76178_() && WaterWalking.canWalkOn(fluid.m_76152_()) && fluid.m_76186_() == 8;
    }

    public static boolean canWalkOn(Fluid fluid) {
        return fluid.m_205067_(FluidTags.f_13131_);
    }

    public static Vec3 collide(BlockGetter world, AABB box, Vec3 offset) {
        if (offset.m_82556_() == 0.0 || offset.f_82480_ >= 0.0) {
            return offset;
        }
        Iterable<VoxelShape> collisions = WaterWalking.collisions(world, box.m_82369_(offset));
        double dy = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)box, collisions, (double)offset.f_82480_);
        return new Vec3(offset.f_82479_, dy, offset.f_82481_);
    }

    public static Iterable<VoxelShape> collisions(BlockGetter world, AABB box) {
        return () -> new CollisionIterator(world, box);
    }

    public static final class CollisionIterator
    extends AbstractIterator<VoxelShape> {
        private final BlockGetter world;
        private final AABB box;
        private final Cursor3D iterator;
        private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

        CollisionIterator(BlockGetter world, AABB box) {
            this.world = world;
            this.box = box;
            this.iterator = new Cursor3D(Mth.m_14107_((double)box.f_82288_), Mth.m_14107_((double)box.f_82289_), Mth.m_14107_((double)box.f_82290_), Mth.m_14107_((double)box.f_82291_), Mth.m_14107_((double)box.f_82292_), Mth.m_14107_((double)box.f_82293_));
        }

        protected VoxelShape computeNext() {
            BlockGetter world = this.world;
            Cursor3D iterator = this.iterator;
            BlockPos.MutableBlockPos mutablePos = this.mutablePos;
            while (iterator.m_122304_()) {
                int z;
                int y;
                int x = iterator.m_122305_();
                if (!WaterWalking.canWalkOn(world.m_6425_((BlockPos)mutablePos.m_122178_(x, y = iterator.m_122306_(), z = iterator.m_122307_()))) || !this.box.m_82314_((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 0.875, (double)z + 1.0)) continue;
                return COLLIDER.m_83216_((double)x, (double)y, (double)z);
            }
            return (VoxelShape)this.endOfData();
        }
    }

    public static final class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob entity, Level world) {
            super(entity, world);
            this.m_7008_(true);
        }

        protected PathFinder m_5532_(int depth) {
            this.f_26508_ = new WalkNodeEvaluator();
            return new PathFinder(this.f_26508_, depth);
        }

        protected boolean m_7367_(BlockPathTypes type) {
            return type == BlockPathTypes.WATER || type == BlockPathTypes.WATER_BORDER || super.m_7367_(type);
        }

        public boolean m_6342_(BlockPos pos) {
            return WaterWalking.canWalkOn(this.f_26495_.m_6425_(pos)) || super.m_6342_(pos);
        }
    }
}

