/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public final class FiddlerCrabEntity
extends Animal {
    private boolean rollingDownTown;
    private boolean travellingGolf;

    public FiddlerCrabEntity(EntityType<? extends FiddlerCrabEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.f_21342_ = new CrabMoveController((Mob)this);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.15f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_267689_(float distance) {
        float rotation = Math.abs(Mth.m_14177_((float)(this.f_20883_ - this.f_20884_)));
        float targetAmount = distance * 4.0f + rotation * 0.25f;
        targetAmount = Math.min(targetAmount, 0.25f);
        this.f_267362_.m_267566_(targetAmount, 0.4f);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public FiddlerCrabEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_6129_() {
        return !this.m_20096_();
    }

    public int m_8085_() {
        return 30;
    }

    public void m_7023_(Vec3 input) {
        if (this.rollingDownTown) {
            this.travelGolf(input);
        } else {
            super.m_7023_(input);
        }
    }

    public void m_147240_(double strength, double x, double z) {
        if (this.rollingDownTown) {
            boolean onGround = this.m_20096_();
            this.m_6853_(false);
            super.m_147240_(strength, x, z);
            this.m_6853_(onGround);
        } else {
            super.m_147240_(strength, x, z);
        }
    }

    private void travelGolf(Vec3 input) {
        if (!this.m_6109_() || this.m_21255_()) {
            super.m_7023_(input);
            return;
        }
        FluidState fluid = this.m_9236_().m_6425_(this.m_20183_());
        if (this.m_6129_() && !this.m_203441_(fluid) && (this.m_20069_() || this.m_20077_() || this.isInFluidType(fluid))) {
            super.m_7023_(input);
            return;
        }
        try {
            this.m_6853_(false);
            this.travellingGolf = true;
            super.m_7023_(input);
        }
        finally {
            this.travellingGolf = false;
        }
    }

    protected BlockPos m_20099_() {
        if (this.travellingGolf) {
            return this.m_20183_().m_175288_(this.m_9236_().m_141937_() - 1);
        }
        return super.m_20099_();
    }

    public boolean m_6094_() {
        return !this.rollingDownTown;
    }

    protected void m_7840_(double y, boolean ground, BlockState state, BlockPos pos) {
        if (this.rollingDownTown) {
            this.m_183634_();
        }
        super.m_7840_(y, ground, state, pos);
    }

    public boolean bounce() {
        if (this.rollingDownTown) {
            Vec3 deltaMovement = this.m_20184_();
            if (Math.abs(deltaMovement.f_82480_) > 0.1) {
                this.m_20334_(deltaMovement.f_82479_, -deltaMovement.f_82480_ * 0.8, deltaMovement.f_82481_);
                return true;
            }
        }
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("RollingDownTown", this.rollingDownTown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.rollingDownTown = tag.m_128471_("RollingDownTown");
    }

    public boolean isRollingDownTown() {
        return this.rollingDownTown;
    }

    public float m_274421_() {
        if (this.rollingDownTown) {
            return 0.0f;
        }
        return super.m_274421_();
    }

    public static boolean canCrabSpawn(EntityType<? extends FiddlerCrabEntity> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundBlock = world.m_8055_(groundPos);
        if (!groundBlock.m_204336_(BlockTags.f_13029_)) {
            return false;
        }
        if (!groundBlock.isValidSpawn((LevelReader)world, groundPos, SpawnPlacements.Type.NO_RESTRICTIONS, type)) {
            return false;
        }
        BlockState block = world.m_8055_(pos);
        FluidState fluid = world.m_6425_(pos);
        return !block.m_60838_((BlockGetter)world, pos) && !block.m_60803_() && !block.m_204336_(BlockTags.f_13054_) && (fluid.m_76178_() || fluid.m_205070_(FluidTags.f_13131_));
    }

    static final class CrabMoveController
    extends MoveControl {
        private static final double RAD_TO_DEG = 57.29577951308232;

        CrabMoveController(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.tickMoveTo();
            } else if (this.f_24981_ == MoveControl.Operation.WAIT) {
                this.f_24974_.m_21564_(0.0f);
                this.f_24974_.m_21570_(0.0f);
            }
        }

        private void tickMoveTo() {
            double dx = this.f_24975_ - this.f_24974_.m_20185_();
            double dz = this.f_24977_ - this.f_24974_.m_20189_();
            double dy = this.f_24976_ - this.f_24974_.m_20186_();
            double distance2 = dx * dx + dy * dy + dz * dz;
            if (distance2 < 2.5E-7) {
                this.f_24974_.m_21564_(0.0f);
                this.f_24974_.m_21570_(0.0f);
                return;
            }
            float forward = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float leftTarget = forward - 90.0f;
            float rightTarget = forward + 90.0f;
            float yaw = this.f_24974_.m_146908_();
            float targetYaw = CrabMoveController.closerAngle(yaw, leftTarget, rightTarget);
            float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
            float strafe = targetYaw < forward ? -1.0f : 1.0f;
            this.f_24974_.m_146922_(this.m_24991_(yaw, targetYaw, 10.0f));
            this.f_24974_.m_7910_(speed);
            this.f_24974_.m_21564_(0.0f);
            this.f_24974_.m_21570_(strafe * speed);
        }

        private static float closerAngle(float reference, float left, float right) {
            float deltaRight;
            float deltaLeft = Math.abs(Mth.m_14177_((float)(reference - left)));
            if (deltaLeft < (deltaRight = Math.abs(Mth.m_14177_((float)(reference - right))))) {
                return left;
            }
            return right;
        }
    }
}

