/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class CowktailEntity
extends Cow
implements IForgeShearable {
    private static final EntityDataAccessor<String> COWKTAIL_TYPE = SynchedEntityData.m_135353_(CowktailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public CowktailEntity(EntityType<? extends CowktailEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50195_ ? 10.0f : worldIn.m_220419_(pos);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COWKTAIL_TYPE, (Object)Type.IRIS.name);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == TropicraftItems.BAMBOO_MUG.get() && !this.m_6162_()) {
            if (player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            ArrayList<RegistryEntry> cocktails = new ArrayList<RegistryEntry>((Collection<RegistryEntry>)TropicraftItems.COCKTAILS.values());
            cocktails.removeIf(cocktail -> cocktail.isPresent() && ((CocktailItem)((Object)((Object)cocktail.get()))).getDrink() == Drink.COCKTAIL);
            ItemStack cocktailItem = new ItemStack((ItemLike)((RegistryEntry)cocktails.get(this.f_19796_.m_188503_(cocktails.size()))).get());
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, cocktailItem);
            } else if (!player.m_150109_().m_36054_(cocktailItem)) {
                player.m_36176_(cocktailItem, false);
            }
            this.m_5496_(SoundEvents.f_12074_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.getCowktailType().name);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCowktailType(Type.getTypeByName(compound.m_128461_("Type")));
    }

    private void setCowktailType(Type typeIn) {
        this.f_19804_.m_135381_(COWKTAIL_TYPE, (Object)typeIn.name);
    }

    public Type getCowktailType() {
        return Type.getTypeByName((String)this.f_19804_.m_135370_(COWKTAIL_TYPE));
    }

    public CowktailEntity getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        CowktailEntity child = (CowktailEntity)((EntityType)TropicraftEntities.COWKTAIL.get()).m_20615_(this.m_9236_());
        child.setCowktailType(this.getOffspringType((CowktailEntity)ageable));
        return child;
    }

    private Type getOffspringType(CowktailEntity cowktail) {
        Type CowktailEntity$type1;
        Type CowktailEntity$type = this.getCowktailType();
        Type CowktailEntity$type2 = CowktailEntity$type == (CowktailEntity$type1 = cowktail.getCowktailType()) && this.f_19796_.m_188503_(1024) == 0 ? Type.getRandomType(this.f_19796_) : (this.f_19796_.m_188499_() ? CowktailEntity$type : CowktailEntity$type1);
        return CowktailEntity$type2;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return !this.m_6162_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.0, 0.0, 0.0);
        if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            Cow cowentity = (Cow)EntityType.f_20557_.m_20615_(this.m_9236_());
            cowentity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            cowentity.m_21153_(this.m_21223_());
            cowentity.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                cowentity.m_6593_(this.m_7770_());
                cowentity.m_20340_(this.m_20151_());
            }
            this.m_9236_().m_7967_((Entity)cowentity);
            for (int i = 0; i < 5; ++i) {
                ret.add(new ItemStack((ItemLike)this.getCowktailType().renderState.m_60734_()));
            }
            this.m_5496_(SoundEvents.f_12075_, 1.0f, 1.0f);
        }
        return ret;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        this.setCowktailType(Type.getRandomType(this.f_19796_));
        return super.m_6518_(world, difficultyInstance, spawnReason, data, nbt);
    }

    public static enum Type {
        IRIS("iris", (BlockState)((TallFlowerBlock)TropicraftBlocks.IRIS.get()).m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER)),
        ANEMONE("anemone", ((TropicsFlowerBlock)((Object)TropicraftBlocks.FLOWERS.get(TropicraftFlower.ANEMONE).get())).m_49966_());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        public static Type getRandomType(RandomSource rand) {
            return (Type)((Object)Util.m_214670_((Object[])Type.values(), (RandomSource)rand));
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type CowktailEntity$type : Type.values()) {
                if (!CowktailEntity$type.name.equals(nameIn)) continue;
                return CowktailEntity$type;
            }
            return IRIS;
        }
    }
}

