/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.DrinkAction;
import net.tropicraft.core.common.drinks.DrinkActionFood;
import net.tropicraft.core.common.drinks.DrinkActionPotion;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class Ingredient
implements Comparable<Ingredient> {
    public static final Ingredient[] ingredientsList = new Ingredient[24];
    public static final Ingredient sugar = new Ingredient(0, (Supplier<? extends ItemLike>)Items.f_42501_.m_204114_(), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient lemon = new Ingredient(5, (Supplier<? extends ItemLike>)TropicraftItems.LEMON, true, 0xFFFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient lime = new Ingredient(6, (Supplier<? extends ItemLike>)TropicraftItems.LIME, true, 0x7FFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient orange = new Ingredient(7, (Supplier<? extends ItemLike>)TropicraftItems.ORANGE, true, 16753920).addAction(new DrinkActionFood(3, 0.2f));
    public static final Ingredient grapefruit = new Ingredient(8, (Supplier<? extends ItemLike>)TropicraftItems.GRAPEFRUIT, true, 16737095).addAction(new DrinkActionFood(4, 0.2f));
    public static final Ingredient pineapple = new Ingredient(9, (Supplier<? extends ItemLike>)TropicraftBlocks.PINEAPPLE, false, 0xEEFF00).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient pineappleCubes = new Ingredient(10, (Supplier<? extends ItemLike>)TropicraftItems.PINEAPPLE_CUBES, false, 0xEEFF00, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconut = new Ingredient(11, (Supplier<? extends ItemLike>)TropicraftBlocks.COCONUT, false, 0xEFEFEF).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconutChunk = new Ingredient(12, (Supplier<? extends ItemLike>)TropicraftItems.COCONUT_CHUNK, false, 0xEFEFEF).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient sugarcane = new Ingredient(13, (Supplier<? extends ItemLike>)Items.f_41909_.m_204114_(), false, 11665259, 0.1f);
    public static final Ingredient roastedCoffeeBean = new Ingredient(14, (Supplier<? extends ItemLike>)TropicraftItems.ROASTED_COFFEE_BEAN, false, 6833196, 0.95f).addAction(new DrinkActionFood(4, 0.2f)).addAction(new DrinkActionPotion(MobEffects.f_19596_, 5, 1));
    public static final Ingredient waterBucket = new Ingredient(15, (Supplier<? extends ItemLike>)Items.f_42447_.m_204114_(), false, 0xFFFFFF);
    public static final Ingredient milkBucket = new Ingredient(16, (Supplier<? extends ItemLike>)Items.f_42455_.m_204114_(), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient cocoaBean = new Ingredient(17, (Supplier<? extends ItemLike>)Items.f_42533_.m_204114_(), false, 8411710, 0.95f).addAction(new DrinkActionFood(4, 0.2f));
    @Nonnull
    private Supplier<? extends ItemLike> item;
    private int color;
    public int id;
    private boolean primary;
    private float alpha = 1.0f;
    private List<DrinkAction> actions = new LinkedList<DrinkAction>();

    public Ingredient() {
        this.item = Items.f_41852_.m_204114_();
    }

    public Ingredient(int id, @Nonnull Supplier<? extends ItemLike> ingredientItem, boolean primary, int color) {
        if (ingredientsList[id] != null) {
            throw new IllegalArgumentException("Ingredient Id slot " + id + " already occupied by " + ingredientsList[id] + "!");
        }
        this.id = id;
        this.item = ingredientItem;
        this.primary = primary;
        this.color = color;
        Ingredient.ingredientsList[id] = this;
    }

    public Ingredient(int id, @Nonnull Supplier<? extends ItemLike> ingredientItem, boolean primary, int color, float alpha) {
        this(id, ingredientItem, primary, color);
        this.alpha = alpha;
    }

    public Ingredient addAction(DrinkAction action) {
        this.actions.add(action);
        return this;
    }

    public Item getIngredientItem() {
        return this.item.get().m_5456_();
    }

    public int getColor() {
        return this.color;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int compareTo(Ingredient other) {
        return Integer.compare(this.id, other.id);
    }

    public void onDrink(Player player) {
        for (DrinkAction action : this.actions) {
            action.onDrink(player);
        }
    }

    public static Ingredient findMatchingIngredient(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Ingredient ingredient : ingredientsList) {
            if (ingredient == null || ingredient.getIngredientItem() != stack.m_41720_()) continue;
            return ingredient;
        }
        return null;
    }

    public static List<Ingredient> listIngredients(ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (!stack.m_41619_() && Drink.isDrink(stack.m_41720_())) {
            Collections.addAll(is, CocktailItem.getIngredients(stack));
        } else if (!stack.m_41619_()) {
            is.add(Ingredient.findMatchingIngredient(stack));
        }
        return is;
    }

    public Component getDisplayName() {
        return new ItemStack((ItemLike)this.getIngredientItem()).m_41786_();
    }
}

