/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TallRainforestTreeFeature
extends RainforestTreeFeature {
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;

    public TallRainforestTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isSoil(LevelAccessor world, BlockPos pos) {
        return this.getSapling().m_7898_(this.getSapling().m_49966_(), (LevelReader)world, pos);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        pos = pos.m_7949_();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        int height = rand.m_188503_(15) + 15;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.m_123342_(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.m_7495_())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.m_122029_().m_7495_())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.m_122024_().m_7495_())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.m_122012_().m_7495_())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.m_122019_().m_7495_())) {
            return false;
        }
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.f_50493_.m_49966_());
        this.setState((LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.f_50493_.m_49966_());
        for (int y = j; y < j + height; ++y) {
            int nz;
            int nx;
            this.placeLog((LevelSimulatedRW)world, i, y, k);
            this.placeLog((LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog((LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog((LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog((LevelSimulatedRW)world, i, y, k + 1);
            if (y - j > height / 2 && rand.m_188503_(3) == 0) {
                nx = rand.m_188503_(3) - 1 + i;
                nz = rand.m_188503_(3) - 1 + k;
                this.genCircle((LevelSimulatedRW)world, new BlockPos(nx, y + 1, nz), 1.0, 0.0, this.getLeaf(), false);
                this.genCircle((LevelSimulatedRW)world, nx, y, nz, 2.0, 1.0, this.getLeaf(), false);
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || rand.m_188503_(3) != 0) continue;
            nx = i + rand.m_188503_(9) - 4;
            nz = k + rand.m_188503_(9) - 4;
            int leafSize = rand.m_188503_(3) + 5;
            this.genCircle((LevelSimulatedRW)world, nx, y + 3, nz, leafSize - 2, 0.0, this.getLeaf(), false);
            this.genCircle((LevelSimulatedRW)world, nx, y + 2, nz, leafSize - 1, leafSize - 3, this.getLeaf(), false);
            this.genCircle((LevelSimulatedRW)world, nx, y + 1, nz, leafSize, leafSize - 1, this.getLeaf(), false);
            this.placeBlockLine((LevelSimulatedRW)world, new int[]{i, y - 2, k}, new int[]{nx, y + 2, nz}, this.getLog());
        }
        int leafSize = rand.m_188503_(5) + 9;
        this.genCircle((LevelSimulatedRW)world, i, j + height, k, leafSize - 2, 0.0, this.getLeaf(), false);
        this.genCircle((LevelSimulatedRW)world, i, j + height - 1, k, leafSize - 1, leafSize - 4, this.getLeaf(), false);
        this.genCircle((LevelSimulatedRW)world, i, j + height - 2, k, leafSize, leafSize - 1, this.getLeaf(), false);
        return true;
    }
}

