/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;

public abstract class PathStructureProcessor
extends CheatyStructureProcessor {
    private static final WeakHashMap<StructurePlaceSettings, List<PathVector>> VECTOR_CACHE = new WeakHashMap();

    protected PathStructureProcessor() {
    }

    @Nullable
    protected Direction.Axis getPathDirection(LevelReader level, BlockPos seedPos, StructureTemplate.StructureBlockInfo current, StructurePlaceSettings settings, StructureTemplate template) {
        StructurePlaceSettings infiniteBounds = settings.m_74374_();
        infiniteBounds.m_74381_(BoundingBox.m_71044_());
        return VECTOR_CACHE.computeIfAbsent(settings, s -> template.m_230335_(seedPos, infiniteBounds, Blocks.f_50678_, true).stream().filter(b -> b.f_74677_().m_128461_("target").equals("tropicraft:path_center")).map(bi -> new PathVector(level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, bi.f_74675_()).m_121996_((Vec3i)seedPos), JigsawBlock.m_54250_((BlockState)bi.f_74676_()))).collect(Collectors.toList())).stream().filter(pv -> pv.contains(current.f_74675_().m_121996_((Vec3i)seedPos), settings)).findFirst().map(pv -> pv.dir.m_122434_()).orElse(null);
    }

    private static class PathVector {
        final Direction dir;
        final BoundingBox bb;

        PathVector(BlockPos start, Direction dir) {
            Preconditions.checkArgument((boolean)dir.m_122434_().m_122479_(), (Object)("Invalid direction for path vector at " + start));
            this.dir = dir;
            Vec3 ortho = Vec3.m_82528_((Vec3i)dir.m_122427_().m_122436_());
            this.bb = this.toMutable(new AABB(start).m_82369_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(16.0)).m_82369_(ortho).m_82369_(ortho.m_82548_()).m_82377_(0.0, 3.0, 0.0));
        }

        boolean contains(BlockPos pos, StructurePlaceSettings settings) {
            return this.bb.m_71051_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)pos));
        }

        private BoundingBox toMutable(AABB bb) {
            return new BoundingBox((int)bb.f_82288_, (int)bb.f_82289_, (int)bb.f_82290_, (int)bb.f_82291_, (int)bb.f_82292_, (int)bb.f_82293_);
        }
    }
}

