/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.registries.RegistryObject;

public class TropicraftFeatureUtil {
    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, RegistryObject<F> feature, FC config) {
        return context.m_255272_(key, (Object)new ConfiguredFeature((Feature)feature.get(), config));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        return context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
    }

    public static <F extends Feature<NoneFeatureConfiguration>> Holder.Reference<ConfiguredFeature<?, ?>> register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, RegistryObject<F> feature) {
        return context.m_255272_(key, (Object)new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<Holder<PlacedFeature>> choices) {
        return context.m_255272_(key, TropicraftFeatureUtil.randomFeature(choices));
    }

    public static ConfiguredFeature<?, ?> randomFeature(List<Holder<PlacedFeature>> choices) {
        if (choices.size() == 2) {
            Holder<PlacedFeature> left = choices.get(0);
            Holder<PlacedFeature> right = choices.get(1);
            return new ConfiguredFeature(Feature.f_65756_, (FeatureConfiguration)new RandomBooleanFeatureConfiguration(left, right));
        }
        return new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205800_(choices)));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<Pair<ResourceKey<PlacedFeature>, Float>> choices, ResourceKey<PlacedFeature> defaultFeature) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        return TropicraftFeatureUtil.registerRandomPlaced(context, key, choices.stream().map(pair -> {
            Holder.Reference holder = placedFeatures.m_255043_((ResourceKey)pair.getFirst());
            return new WeightedPlacedFeature((Holder)holder, ((Float)pair.getSecond()).floatValue());
        }).toList(), defaultFeature);
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandomPlaced(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, List<WeightedPlacedFeature> choices, ResourceKey<PlacedFeature> defaultFeatureKey) {
        Holder.Reference defaultFeature = context.m_255420_(Registries.f_256988_).m_255043_(defaultFeatureKey);
        return TropicraftFeatureUtil.register(context, key, Feature.f_65754_, new RandomFeatureConfiguration(choices, (Holder)defaultFeature));
    }

    @SafeVarargs
    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandom(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, ResourceKey<ConfiguredFeature<?, ?>> ... choiceKeys) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        return TropicraftFeatureUtil.registerRandom(context, key, Arrays.stream(choiceKeys).map(k -> PlacementUtils.m_206506_((Holder)configuredFeatures.m_255043_(k), (PlacementModifier[])new PlacementModifier[0])).toList());
    }

    @SafeVarargs
    public static Holder.Reference<ConfiguredFeature<?, ?>> registerRandomPlaced(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, ResourceKey<PlacedFeature> ... choices) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        return TropicraftFeatureUtil.registerRandom(context, key, Arrays.stream(choices).map(arg_0 -> ((HolderGetter)placedFeatures).m_255043_(arg_0)).collect(Collectors.toList()));
    }

    public static RandomPatchConfiguration randomPatch(Supplier<? extends Block> block) {
        return TropicraftFeatureUtil.randomPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.get()));
    }

    public static RandomPatchConfiguration randomPatch(BlockStateProvider blockStateProvider) {
        return FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider));
    }

    public static OreConfiguration ore(int blobSize, Supplier<? extends Block> block) {
        TagMatchTest stoneOreReplaceables = new TagMatchTest(BlockTags.f_144266_);
        return new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)stoneOreReplaceables, (BlockState)block.get().m_49966_())), blobSize);
    }

    public static BlockStateProvider stateProvider(Supplier<? extends Block> block) {
        return BlockStateProvider.m_191382_((Block)block.get());
    }

    public static boolean goesBeyondWorldSize(WorldGenLevel world, int y, int height) {
        return y < world.m_141937_() + 1 || y + height + 1 > world.m_151558_();
    }

    public static boolean isBBAvailable(WorldGenLevel world, BlockPos pos, int height) {
        for (int y = 0; y <= 1 + height; ++y) {
            BlockPos checkPos = pos.m_6630_(y);
            int size = 1;
            if (checkPos.m_123342_() < world.m_141937_() || checkPos.m_123342_() >= world.m_151558_()) {
                return false;
            }
            if (y == 0) {
                size = 0;
            }
            if (y >= 1 + height - 2) {
                size = 2;
            }
            if (!BlockPos.m_121990_((BlockPos)checkPos.m_7918_(-size, 0, -size), (BlockPos)checkPos.m_7918_(size, 0, size)).anyMatch(p -> !TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)p))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSoil(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        return block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50440_ || block == Blocks.f_50599_;
    }
}

