/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class ReedsFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState REEDS = ((ReedsBlock)((Object)TropicraftBlocks.REEDS.get())).m_49966_();
    private static final int HEIGHT_ABOVE_WATER = 2;
    private static final int MAX_HEIGHT = 3;
    private static final int MAX_DEPTH = 3;

    public ReedsFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        if (!world.m_8055_(origin).m_60713_(Blocks.f_49990_) || !world.m_46859_(origin.m_7494_())) {
            return false;
        }
        boolean generated = false;
        BlockPos.MutableBlockPos bottomPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 32; ++i) {
            int x = origin.m_123341_() + random.m_188503_(8) - random.m_188503_(8);
            int z = origin.m_123343_() + random.m_188503_(8) - random.m_188503_(8);
            int y = world.m_6924_(Heightmap.Types.OCEAN_FLOOR, x, z);
            bottomPos.m_122178_(x, y, z);
            generated |= this.generateOne(world, (BlockPos)bottomPos, random, mutablePos);
        }
        return generated;
    }

    private boolean generateOne(WorldGenLevel world, BlockPos pos, RandomSource random, BlockPos.MutableBlockPos mutablePos) {
        if (!REEDS.m_60710_((LevelReader)world, pos) || !this.canReplace(world.m_8055_(pos))) {
            return false;
        }
        int waterDepth = this.getWaterDepthAt(world, pos, mutablePos);
        int height = waterDepth + random.m_188503_(2) + 1;
        if (!this.validateHeight(world, pos, height, mutablePos)) {
            return false;
        }
        if (height == 1) {
            this.generateShort(world, pos);
        } else {
            this.generateTall(world, pos, height, mutablePos);
        }
        return true;
    }

    private boolean validateHeight(WorldGenLevel world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos) {
        if (height > 3) {
            return false;
        }
        mutablePos.m_122190_((Vec3i)pos);
        for (int y = height; y >= 0; --y) {
            mutablePos.m_142448_(pos.m_123342_() + height);
            if (this.canReplace(world.m_8055_((BlockPos)mutablePos))) continue;
            return false;
        }
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.m_60713_(Blocks.f_49990_) || state.m_60795_();
    }

    private int getWaterDepthAt(WorldGenLevel world, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        int depth = 0;
        mutablePos.m_122190_((Vec3i)pos);
        while (world.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_49990_)) {
            mutablePos.m_122173_(Direction.UP);
            if (++depth < 3) continue;
            break;
        }
        return depth;
    }

    private void generateShort(WorldGenLevel world, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)REEDS.m_61124_(ReedsBlock.TYPE, (Comparable)((Object)ReedsBlock.Type.SINGLE))).m_61124_((Property)ReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        world.m_7731_(pos, state, 2);
    }

    private boolean generateTall(WorldGenLevel world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos) {
        for (int y = 0; y < height; ++y) {
            mutablePos.m_142448_(pos.m_123342_() + y);
            BlockState state = (BlockState)((BlockState)REEDS.m_61124_(ReedsBlock.TYPE, (Comparable)((Object)(y == height - 1 ? ReedsBlock.Type.TOP : ReedsBlock.Type.BOTTOM)))).m_61124_((Property)ReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_49990_)));
            world.m_7731_((BlockPos)mutablePos, state, 2);
        }
        return true;
    }
}

