/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class FishingBobberEntityRenderer
extends EntityRenderer<FishingBobberEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION);

    public FishingBobberEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(FishingBobberEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float handOffset;
        EntityKoaBase koa = entity.getAngler();
        if (koa == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        VertexConsumer consumer = bufferSource.m_6299_(RENDER_TYPE);
        FishingBobberEntityRenderer.vertex(consumer, pose, normal, packedLight, 0.0f, 0, 0, 1);
        FishingBobberEntityRenderer.vertex(consumer, pose, normal, packedLight, 1.0f, 0, 1, 1);
        FishingBobberEntityRenderer.vertex(consumer, pose, normal, packedLight, 1.0f, 1, 1, 0);
        FishingBobberEntityRenderer.vertex(consumer, pose, normal, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
        float f = handOffset = koa.m_5737_() == HumanoidArm.RIGHT ? 0.35f : -0.35f;
        if (!koa.m_21205_().m_150930_(Items.f_42523_)) {
            handOffset = -handOffset;
        }
        float yBodyRot = Mth.m_14179_((float)partialTicks, (float)koa.f_20884_, (float)koa.f_20883_) * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)yBodyRot);
        float cos = Mth.m_14089_((float)yBodyRot);
        double rodX = Mth.m_14139_((double)partialTicks, (double)koa.f_19854_, (double)koa.m_20185_()) - (double)(cos * handOffset) - (double)sin * 0.8;
        double rodY = koa.f_19855_ + (double)koa.m_20192_() + (koa.m_20186_() - koa.f_19855_) * (double)partialTicks - 0.45;
        double rodZ = Mth.m_14139_((double)partialTicks, (double)koa.f_19856_, (double)koa.m_20189_()) - (double)(sin * handOffset) + (double)cos * 0.8;
        float offset = koa.m_6047_() ? -0.1875f : 0.0f;
        double bobberX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        double bobberY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.25;
        double bobberZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        float deltaX = (float)(rodX - bobberX);
        float deltaY = (float)(rodY - bobberY) + offset;
        float deltaZ = (float)(rodZ - bobberZ);
        VertexConsumer line = bufferSource.m_6299_(RenderType.m_173247_());
        for (int i = 0; i <= 16; ++i) {
            FishingBobberEntityRenderer.stringVertex(deltaX, deltaY, deltaZ, line, poseStack.m_85850_(), (float)i / 16.0f, (float)(i + 1) / 16.0f);
        }
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int p_114715_, float p_114716_, int p_114717_, int p_114718_, int p_114719_) {
        consumer.m_252986_(pose, p_114716_ - 0.5f, (float)p_114717_ - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)p_114718_, (float)p_114719_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114715_).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float deltaX, float deltaY, float deltaZ, VertexConsumer consumer, PoseStack.Pose pose, float start, float end) {
        float x = deltaX * start;
        float y = deltaY * (start * start + start) * 0.5f + 0.25f;
        float z = deltaZ * start;
        float normalX = deltaX * end - x;
        float normalY = deltaY * (end * end + end) * 0.5f + 0.25f - y;
        float normalZ = deltaZ * end - z;
        float length = Mth.m_14116_((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        consumer.m_252986_(pose.m_252922_(), x, y, z).m_6122_(0, 0, 0, 255).m_252939_(pose.m_252943_(), normalX /= length, normalY /= length, normalZ /= length).m_5752_();
    }

    public ResourceLocation getTextureLocation(FishingBobberEntity pEntity) {
        return TEXTURE_LOCATION;
    }
}

