/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

public class AshenModel
extends ListModel<AshenEntity>
implements ArmedModel {
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightArmSub;
    public final ModelPart leftArmSub;
    public boolean swinging;

    public AshenModel(ModelPart root) {
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArmSub = this.rightArm.m_171324_("right_arm_sub");
        this.leftArmSub = this.leftArm.m_171324_("left_arm_sub");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171480_().m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171480_().m_171481_(-1.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 8).m_171480_().m_171481_(-2.0f, -3.0f, 0.0f, 4.0f, 7.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)2.0f, (float)0.0f, (float)3.141593f, (float)0.0f));
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171480_().m_171481_(-2.0f, -3.0f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)1.0f, (float)0.0f, (float)3.141593f, (float)0.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171480_().m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_sub", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171481_(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171480_().m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)10.46667f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_sub", CubeListBuilder.m_171558_().m_171555_(true).m_171514_(31, 0).m_171481_(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(AshenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float headAngle;
        float armRotater = 1.2472123f;
        float subStraight = 1.5707964f;
        switch (entity.getActionState()) {
            case LOST_MASK: {
                headAngle = -0.4f;
                this.rightArm.f_104205_ = -1.2472123f;
                this.rightArmSub.f_104205_ = -5.1f;
                this.leftArm.f_104205_ = 1.2472123f;
                this.leftArmSub.f_104205_ = 5.1f;
                this.leftArm.f_104203_ = 1.5707964f;
                this.rightArm.f_104203_ = 1.5707964f;
                this.rightArm.f_104204_ = -0.5f;
                this.leftArm.f_104204_ = 0.5f;
                break;
            }
            case HOSTILE: {
                headAngle = 0.0f;
                this.leftArm.f_104203_ = 1.65f + limbSwing / 125.0f;
                this.leftArm.f_104204_ = 0.9f + limbSwingAmount / 125.0f;
                this.leftArm.f_104205_ = 1.2472123f;
                this.leftArmSub.f_104205_ = 6.2f;
                this.rightArm.f_104205_ = 0.0f - Mth.m_14031_((float)(limbSwingAmount * 0.75f)) * 0.022f;
                this.rightArm.f_104204_ = 0.0f;
                this.rightArmSub.f_104205_ = 0.0f;
                if (this.swinging) {
                    this.rightArm.f_104203_ += Mth.m_14031_((float)(limbSwingAmount * 0.75f)) * 0.052f;
                    break;
                }
                this.rightArm.f_104203_ = 0.0f;
                break;
            }
            default: {
                headAngle = 0.0f;
                this.rightArm.f_104205_ = -1.2472123f;
                this.rightArmSub.f_104205_ = -1.5707964f;
                this.leftArm.f_104205_ = 1.2472123f;
                this.leftArmSub.f_104205_ = 1.5707964f;
                this.rightArm.f_104204_ = 0.0f;
                this.leftArm.f_104204_ = 0.0f;
            }
        }
        this.head.f_104203_ = headPitch / 125.0f + headAngle;
        this.head.f_104204_ = netHeadYaw / 125.0f + (float)Math.PI;
        this.leftArm.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.25f)) * 0.02f;
        this.rightArm.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.25f)) * 0.02f;
    }

    public Iterable<ModelPart> m_6195_() {
        return List.of(this.body, this.head, this.rightArm, this.leftArm, this.leftLeg, this.rightLeg);
    }

    public void prepareMobModel(AshenEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.25f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.141593f)) * 1.25f * limbSwingAmount;
    }

    public void m_6002_(HumanoidArm side, PoseStack stack) {
        stack.m_252880_(0.09375f, 0.1875f, 0.0f);
    }
}

