/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.init.registries;

import cofh.lib.common.block.AttachedStemBlockCoFH;
import cofh.lib.common.block.CakeBlockCoFH;
import cofh.lib.common.block.CropBlockCoFH;
import cofh.lib.common.block.CropBlockMushroom;
import cofh.lib.common.block.DirectionalBlock4Way;
import cofh.lib.common.block.FeastBlock;
import cofh.lib.common.block.StemBlockCoFH;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.block.ChargedSoilBlock;
import cofh.thermal.core.common.block.TilledChargedSoilBlock;
import cofh.thermal.core.init.registries.ThermalCreativeTabs;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.cultivation.common.block.AmaranthCrop;
import cofh.thermal.cultivation.common.block.CheeseWheelBlock;
import cofh.thermal.cultivation.common.block.FlaxCrop;
import cofh.thermal.cultivation.common.block.FrostMelonBlock;
import cofh.thermal.cultivation.common.block.PotionCakeBlock;
import cofh.thermal.cultivation.common.config.ThermalCropConfig;
import cofh.thermal.cultivation.common.item.PotionCakeBlockItem;
import cofh.thermal.cultivation.init.registries.TCulFoods;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class TCulBlocks {
    protected static final ResourceKey<DamageType> SADIROOT_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("thermal", "sadiroot"));

    private TCulBlocks() {
    }

    public static void register() {
        TCulBlocks.registerPlants();
        TCulBlocks.registerFoods();
        TCulBlocks.registerStorage();
        TCulBlocks.registerMisc();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_((Block)ThermalCore.BLOCKS.get(RegistrationHelper.block((String)"amaranth")), 60, 20);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get(RegistrationHelper.block((String)"barley")), 60, 20);
        fire.m_53444_((Block)ThermalCore.BLOCKS.get(RegistrationHelper.block((String)"flax")), 60, 20);
        float chance = 0.65f;
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("amaranth")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("barley")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("corn")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("flax")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("onion")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("radish")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("rice")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("sadiroot")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("spinach")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("bell_pepper")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("eggplant")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("green_bean")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("peanut")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("strawberry")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("tomato")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("coffee")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("tea")));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("frost_melon")));
        chance = 0.5f;
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("frost_melon_slice")));
        chance = 0.3f;
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"amaranth"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"barley"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"corn"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"flax"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"onion"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"radish"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"rice"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"sadiroot"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"spinach"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"bell_pepper"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"eggplant"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"green_bean"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"peanut"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"strawberry"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"tomato"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"coffee"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"tea"))));
        ComposterBlock.m_51920_((float)chance, (ItemLike)((ItemLike)ThermalCore.ITEMS.get(RegistrationHelper.seeds((String)"frost_melon"))));
    }

    private static void registerPlants() {
        TCulBlocks.registerAmaranth("amaranth");
        RegistrationHelper.registerAnnual((String)"barley");
        RegistrationHelper.registerTallAnnual((String)"corn");
        TCulBlocks.registerFlax("flax");
        RegistrationHelper.registerAnnual((String)"onion");
        RegistrationHelper.registerAnnual((String)"radish");
        RegistrationHelper.registerAnnual((String)"rice");
        ThermalCore.BLOCKS.register("sadiroot", () -> new CropBlockCoFH(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)){

            public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
                if (entity instanceof LivingEntity && entity.m_6095_() != EntityType.f_20452_ && entity.m_6095_() != EntityType.f_20550_) {
                    entity.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
                    if (!(world.f_46443_ || (Integer)state.m_61143_((Property)this.m_7959_()) <= 4 || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_())) {
                        double d0 = Math.abs(entity.m_20185_() - entity.f_19790_);
                        double d1 = Math.abs(entity.m_20189_() - entity.f_19792_);
                        if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                            entity.m_6469_(entity.f_19853_.m_269111_().m_269079_(SADIROOT_DAMAGE), 1.0f);
                        }
                    }
                }
                super.m_7892_(state, world, pos, entity);
            }
        }.crop((Supplier)ThermalCore.ITEMS.getSup("sadiroot")).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)"sadiroot"))));
        RegistrationHelper.registerAnnual((String)"spinach");
        RegistrationHelper.registerPerennial((String)"bell_pepper");
        RegistrationHelper.registerPerennial((String)"eggplant");
        RegistrationHelper.registerPerennial((String)"green_bean");
        RegistrationHelper.registerPerennial((String)"peanut");
        RegistrationHelper.registerPerennial((String)"strawberry");
        RegistrationHelper.registerPerennial((String)"tomato");
        RegistrationHelper.registerPerennial((String)"coffee", (int)6);
        RegistrationHelper.registerPerennial((String)"tea");
        ThermalCore.BLOCKS.register("glowstone_mushroom", () -> new CropBlockMushroom(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56761_).m_60953_(state -> (Integer)state.m_61143_((Property)BlockStatePropertiesCoFH.AGE_0_4) == 4 ? 12 : 0)){

            public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
                return ThermalCropConfig.glowstoneMushroomLight.get() != false ? state.m_60791_() : 0;
            }
        }.seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)"glowstone_mushroom"))));
        TCulBlocks.registerMushroom("gunpowder_mushroom");
        ThermalCore.BLOCKS.register("redstone_mushroom", () -> new CropBlockMushroom(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56761_).m_60953_(state -> (Integer)state.m_61143_((Property)BlockStatePropertiesCoFH.AGE_0_4) == 4 ? 7 : 0)){

            public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
                return ThermalCropConfig.redstoneMushroomLight.get() != false ? state.m_60791_() : 0;
            }

            public boolean m_7899_(BlockState state) {
                return ThermalCropConfig.redstoneMushroomSignal.get();
            }

            public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
                return ThermalCropConfig.redstoneMushroomSignal.get() != false && (Integer)blockState.m_61143_((Property)BlockStatePropertiesCoFH.AGE_0_4) == 4 ? 7 : 0;
            }
        }.seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)"redstone_mushroom"))));
        TCulBlocks.registerMushroom("slime_mushroom");
        RegistrationHelper.registerBlock((String)"frost_melon", () -> new FrostMelonBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283772_).m_60977_().m_60978_(1.0f).m_60918_(SoundType.f_56747_)), (Rarity)Rarity.UNCOMMON, (String)"thermal_cultivation");
        RegistrationHelper.registerBlockOnly((String)"frost_melon_stem", () -> new StemBlockCoFH(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60977_().m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56736_), (Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)"frost_melon"))).crop((Supplier)ThermalCore.BLOCKS.getSup("frost_melon")));
        RegistrationHelper.registerBlockOnly((String)"frost_melon_stem_attached", () -> new AttachedStemBlockCoFH(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56759_), (Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)"frost_melon"))).crop((Supplier)ThermalCore.BLOCKS.getSup("frost_melon")));
    }

    private static void registerFoods() {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"cheese_wheel", () -> new CheeseWheelBlock(BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(1.0f).m_60918_(SoundType.f_56745_), TCulFoods.CHEESE).serving((Supplier)ThermalCore.ITEMS.getSup("cheese_wedge")), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"stuffed_pumpkin", () -> new FeastBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56736_), TCulFoods.STUFFED_PUMPKIN), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"carrot_cake", () -> new CakeBlockCoFH(BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_), TCulFoods.CARROT_CAKE).setTall(), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"chocolate_cake", () -> new CakeBlockCoFH(BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_), TCulFoods.CHOCOLATE_CAKE), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"potion_cake", () -> new PotionCakeBlock(BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY), TCulFoods.POTION_CAKE), () -> new PotionCakeBlockItem((Block)ThermalCore.BLOCKS.get("potion_cake"), new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)"spice_cake", () -> new CakeBlockCoFH(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56745_), TCulFoods.SPICE_CAKE), (String)"thermal_cultivation"));
    }

    private static void registerStorage() {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"amaranth"), () -> new HayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60978_(0.5f).m_60918_(SoundType.f_56740_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"barley"), () -> new HayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60978_(0.5f).m_60918_(SoundType.f_56740_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"corn"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"flax"), () -> new HayBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(0.5f).m_60918_(SoundType.f_56740_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"onion"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"radish"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"sadiroot"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"spinach"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"bell_pepper"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"eggplant"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283892_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"green_bean"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"hops"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"strawberry"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"tomato"), () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60978_(1.5f).m_60918_(SoundType.f_56756_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"rice"), () -> new DirectionalBlock4Way(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60978_(0.5f).m_60918_(SoundType.f_56719_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"peanut"), () -> new DirectionalBlock4Way(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283774_).m_60978_(0.5f).m_60918_(SoundType.f_56719_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"coffee"), () -> new DirectionalBlock4Way(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60978_(0.5f).m_60918_(SoundType.f_56719_)), (String)"thermal_cultivation"));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"tea"), () -> new DirectionalBlock4Way(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_60978_(0.5f).m_60918_(SoundType.f_56719_)), (String)"thermal_cultivation"));
    }

    private static void registerMisc() {
        RegistrationHelper.registerBlock((String)"phytosoil", () -> new ChargedSoilBlock(BlockBehaviour.Properties.m_284310_().m_60977_().m_60978_(0.8f).m_60918_(SoundType.f_56739_).m_60953_(state -> (Integer)state.m_61143_((Property)ChargedSoilBlock.CHARGED) > 0 ? 7 : 0)).otherBlock((Supplier)ThermalCore.BLOCKS.getSup("phytosoil_tilled")), (String)"thermal_cultivation");
        RegistrationHelper.registerBlock((String)"phytosoil_tilled", () -> new TilledChargedSoilBlock(BlockBehaviour.Properties.m_284310_().m_60977_().m_60978_(0.8f).m_60918_(SoundType.f_56739_).m_60953_(state -> (Integer)state.m_61143_((Property)ChargedSoilBlock.CHARGED) > 0 ? 7 : 0)).otherBlock((Supplier)ThermalCore.BLOCKS.getSup("phytosoil")), (String)"thermal_cultivation");
    }

    private static void registerAmaranth(String id) {
        ThermalCore.BLOCKS.register(id, () -> new AmaranthCrop(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)id))));
    }

    private static void registerFlax(String id) {
        ThermalCore.BLOCKS.register(id, () -> new FlaxCrop(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56758_)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)id))));
    }

    private static void registerMushroom(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropBlockMushroom(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60913_(0.0f, 0.0f).m_60918_(SoundType.f_56761_)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)id))));
    }
}

