/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.event.ClientChunkUpdatedEvent;
import com.minecolonies.api.util.ChunkCapData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ChunkClientDataHelper {
    private static final List<ChunkCapData> chunkCapsToAdd = new ArrayList<ChunkCapData>();

    public static void addCapData(ChunkCapData chunkCap) {
        chunkCapsToAdd.add(chunkCap);
    }

    public static void applyLate(LevelChunk chunk) {
        if (chunkCapsToAdd.isEmpty()) {
            return;
        }
        Iterator<ChunkCapData> iterator = chunkCapsToAdd.iterator();
        while (iterator.hasNext()) {
            ChunkCapData chunkCapData = iterator.next();
            if (chunk.m_7697_().f_45578_ != chunkCapData.x || chunk.m_7697_().f_45579_ != chunkCapData.z) continue;
            ChunkClientDataHelper.applyCap(chunkCapData, chunk);
            iterator.remove();
        }
    }

    public static void applyCap(ChunkCapData chunkCapData, LevelChunk chunk) {
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap != null) {
            cap.setOwningColony(chunkCapData.getOwningColony(), chunk);
            cap.setStaticColonyClaim(chunkCapData.getStaticColonyClaim());
        }
        MinecraftForge.EVENT_BUS.post((Event)new ClientChunkUpdatedEvent(chunk));
    }
}

