/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerRack;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack
implements IMateriallyTexturedBlockEntity {
    private static final byte VERSION = 2;
    private byte version = 0;
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private int freeSlots = 0;
    private LazyOptional<IItemHandler> lastOptional;
    private static final List<ResourceLocation> textureMapping = ImmutableList.builder().add((Object)new ResourceLocation("block/bricks")).add((Object)new ResourceLocation("block/sand")).add((Object)new ResourceLocation("block/orange_wool")).add((Object)new ResourceLocation("block/dirt")).add((Object)new ResourceLocation("block/obsidian")).add((Object)new ResourceLocation("block/polished_andesite")).add((Object)new ResourceLocation("block/andesite")).add((Object)new ResourceLocation("block/blue_wool")).build();
    private static final List<ResourceLocation> secondarytextureMapping = ImmutableList.builder().add((Object)new ResourceLocation("block/oak_log")).add((Object)new ResourceLocation("block/spruce_log")).add((Object)new ResourceLocation("block/birch_log")).add((Object)new ResourceLocation("block/jungle_log")).add((Object)new ResourceLocation("block/acacia_log")).add((Object)new ResourceLocation("block/dark_oak_log")).add((Object)new ResourceLocation("block/mangrove_log")).add((Object)new ResourceLocation("block/crimson_stem")).build();
    private MaterialTextureData textureDataCache = new MaterialTextureData();
    private boolean checkedAfterStartup = false;

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.freeSlots = this.inventory.getSlots();
    }

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state, int size) {
        super(type, pos, state, size);
        this.size = (size - 27) / 9;
        this.freeSlots = this.inventory.getSlots();
    }

    public TileEntityRack(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.RACK.get(), pos, state);
    }

    @Override
    public void setInWarehouse(Boolean isInWarehouse) {
        this.inWarehouse = isInWarehouse;
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count, boolean ignoreDamageValue) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue);
        return this.content.getOrDefault(checkItem, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack, boolean ignoreDamageValue, boolean ignoreNBT) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue, ignoreNBT);
        return this.getCount(checkItem);
    }

    @Override
    protected void updateBlockState() {
    }

    @Override
    public int getCount(ItemStorage storage) {
        if (storage.ignoreDamageValue() || storage.ignoreNBT()) {
            if (!this.content.containsKey(storage)) {
                return 0;
            }
            int count = 0;
            for (Map.Entry<ItemStorage, Integer> contentStorage : this.content.entrySet()) {
                if (!contentStorage.getKey().equals(storage)) continue;
                count += contentStorage.getValue().intValue();
            }
            return count;
        }
        return this.content.getOrDefault(storage, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack, true, true);
        if (this.content.containsKey(checkItem)) {
            return true;
        }
        for (ItemStorage storage : this.content.keySet()) {
            if (IColonyManager.getInstance().getCompatibilityManager().getCreativeTab(checkItem) != IColonyManager.getInstance().getCompatibilityManager().getCreativeTab(storage)) continue;
            return true;
        }
        return false;
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeRackSize() {
        ++this.size;
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(27 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        int matched = 0;
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            matched += entry.getValue().intValue();
        }
        return matched;
    }

    @Override
    public void updateItemStorage() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean beforeEmpty = this.content.isEmpty();
            this.updateContent();
            if (this.m_58900_().m_60734_() == ModBlocks.blockRack) {
                boolean afterEmpty = this.content.isEmpty();
                AbstractTileEntityRack potentialNeighbor = this.getOtherChest();
                if (potentialNeighbor instanceof TileEntityRack && !((TileEntityRack)potentialNeighbor).isEmpty()) {
                    afterEmpty = false;
                }
                if (beforeEmpty && !afterEmpty || !beforeEmpty && afterEmpty) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)((RackType)((Object)this.m_58900_().m_61143_(AbstractBlockMinecoloniesRack.VARIANT))).getInvBasedVariant(afterEmpty))));
                    if (potentialNeighbor != null) {
                        this.f_58857_.m_46597_(potentialNeighbor.m_58899_(), (BlockState)potentialNeighbor.m_58900_().m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)((RackType)((Object)potentialNeighbor.m_58900_().m_61143_(AbstractBlockMinecoloniesRack.VARIANT))).getInvBasedVariant(afterEmpty))));
                    }
                }
            }
            this.m_6596_();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack)) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.m_41777_());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public AbstractTileEntityRack getOtherChest() {
        if (this.m_58900_().m_60734_() != ModBlocks.blockRack) {
            return null;
        }
        RackType type = (RackType)((Object)this.m_58900_().m_61143_(AbstractBlockMinecoloniesRack.VARIANT));
        if (!type.isDoubleVariant()) {
            return null;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)AbstractBlockMinecoloniesRack.FACING)));
        if (tileEntity instanceof TileEntityRack && !(tileEntity instanceof AbstractTileEntityColonyBuilding)) {
            return (AbstractTileEntityRack)tileEntity;
        }
        return null;
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("tagSIze")) {
            this.size = compound.m_128451_("tagSIze");
            this.inventory = this.createInventory(27 + this.size * 9);
        }
        ListTag inventoryTagList = compound.m_128437_("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundTag inventoryCompound = inventoryTagList.m_128728_(i);
            if (inventoryCompound.m_128441_("empty")) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)inventoryCompound);
            this.inventory.setStackInSlot(i, stack);
        }
        this.updateContent();
        this.inWarehouse = compound.m_128471_("inWarehouse");
        if (compound.m_128441_("pos")) {
            this.buildingPos = BlockPosUtil.read(compound, "pos");
        }
        this.version = compound.m_128445_("version");
        this.invalidateCap();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.refreshTextureCache();
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tagSIze", this.size);
        @NotNull ListTag inventoryTagList = new ListTag();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundTag inventoryCompound = new CompoundTag();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) {
                inventoryCompound.m_128379_("empty", true);
            } else {
                stack.m_41739_(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.m_128365_("inventory", (Tag)inventoryTagList);
        compound.m_128379_("inWarehouse", this.inWarehouse);
        BlockPosUtil.write(compound, "pos", this.buildingPos);
        compound.m_128344_("version", this.version);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (this.version != 2) {
            this.version = (byte)2;
        }
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (this.lastOptional != null && this.lastOptional.isPresent()) {
                return this.lastOptional.cast();
            }
            if (this.m_58900_().m_60734_() != ModBlocks.blockRack) {
                this.lastOptional = LazyOptional.of(() -> {
                    if (this.m_58901_()) {
                        return new AbstractTileEntityRack.RackInventory(0);
                    }
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                });
                return this.lastOptional.cast();
            }
            RackType type = (RackType)((Object)this.m_58900_().m_61143_(AbstractBlockMinecoloniesRack.VARIANT));
            if (!type.isDoubleVariant()) {
                this.lastOptional = LazyOptional.of(() -> {
                    if (this.m_58901_()) {
                        return new AbstractTileEntityRack.RackInventory(0);
                    }
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                });
                return this.lastOptional.cast();
            }
            this.lastOptional = LazyOptional.of(() -> {
                if (this.m_58901_()) {
                    return new AbstractTileEntityRack.RackInventory(0);
                }
                AbstractTileEntityRack other = this.getOtherChest();
                if (other == null) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                }
                if (type != RackType.EMPTYAIR) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory(), other.getInventory());
                }
                return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", other.getInventory(), this.getInventory());
            });
            return this.lastOptional.cast();
        }
        return super.getCapability(capability, dir);
    }

    @Override
    public int getUpgradeSize() {
        return this.size;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
            super.m_6596_();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        this.refreshTextureCache();
        return new ContainerRack(id, inv, this.m_58899_(), this.getOtherChest() == null ? BlockPos.f_121853_ : this.getOtherChest().m_58899_());
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Rack");
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCap();
    }

    private void invalidateCap() {
        if (this.lastOptional != null && this.lastOptional.isPresent()) {
            this.lastOptional.invalidate();
        }
        this.lastOptional = null;
    }

    public void updateTextureDataWith(MaterialTextureData materialTextureData) {
    }

    private void refreshTextureCache() {
        HashMap<ResourceLocation, Block> resMap = new HashMap<ResourceLocation, Block>();
        int displayPerSlots = this.getInventory().getSlots() / 4;
        int index = 0;
        boolean update = false;
        boolean alreadyAddedItem = false;
        HashMap<ItemStorage, Integer> mapCopy = new HashMap<ItemStorage, Integer>(this.content);
        Object object = this.getOtherChest();
        if (object instanceof TileEntityRack) {
            TileEntityRack neighborRack = (TileEntityRack)((Object)object);
            for (Map.Entry entry : neighborRack.content.entrySet()) {
                int value = (Integer)entry.getValue() + mapCopy.getOrDefault(entry.getKey(), 0);
                mapCopy.put((ItemStorage)entry.getKey(), value);
            }
        }
        List list = mapCopy.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).toList();
        ArrayDeque<Object> extraBlockQueue = new ArrayDeque<Object>();
        ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
        for (Map.Entry entry : list) {
            int displayRows;
            if (index >= textureMapping.size()) break;
            Block block = Blocks.f_50618_;
            boolean isBlockItem = false;
            Item item = ((ItemStorage)entry.getKey()).getItemStack().m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
                isBlockItem = true;
            }
            if ((displayRows = (int)Math.ceil(Math.max(1.0, (double)((Integer)entry.getValue()).intValue() / (double)((ItemStorage)entry.getKey()).getItemStack().m_41741_()) / (double)displayPerSlots)) > 1) {
                for (int i = 0; i < displayRows - 1; ++i) {
                    if (isBlockItem) {
                        extraBlockQueue.add(block);
                        continue;
                    }
                    arrayDeque.add(block);
                }
            }
            if (!isBlockItem) {
                if (alreadyAddedItem) {
                    arrayDeque.add(block);
                    continue;
                }
                alreadyAddedItem = true;
            }
            if ((Integer)entry.getValue() < 16 && !extraBlockQueue.isEmpty()) {
                block = (Block)extraBlockQueue.poll();
            }
            ResourceLocation secondaryResLoc = secondarytextureMapping.get(index);
            if (!block.m_49966_().m_60804_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
                resMap.put(secondaryResLoc, block);
                block = Blocks.f_50618_;
            } else {
                resMap.put(secondaryResLoc, Blocks.f_50016_);
            }
            ResourceLocation resLoc = textureMapping.get(index);
            resMap.put(resLoc, block);
            if (this.textureDataCache == null || !this.textureDataCache.getTexturedComponents().getOrDefault(resLoc, Blocks.f_50752_).equals(resMap.get(resLoc)) || !this.textureDataCache.getTexturedComponents().getOrDefault(secondaryResLoc, Blocks.f_50752_).equals(resMap.get(secondaryResLoc))) {
                update = true;
            }
            ++index;
        }
        extraBlockQueue.addAll(arrayDeque);
        for (int i = index; i < textureMapping.size(); ++i) {
            Block block = Blocks.f_50016_;
            if (!extraBlockQueue.isEmpty()) {
                block = (Block)extraBlockQueue.poll();
            }
            ResourceLocation secondaryResLoc = secondarytextureMapping.get(i);
            if (block != Blocks.f_50016_ && !block.m_49966_().m_60804_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
                resMap.put(secondaryResLoc, block);
                block = Blocks.f_50618_;
            } else {
                resMap.put(secondaryResLoc, Blocks.f_50016_);
            }
            ResourceLocation resLoc = textureMapping.get(i);
            resMap.put(resLoc, block);
            if (this.textureDataCache != null && this.textureDataCache.getTexturedComponents().getOrDefault(resLoc, Blocks.f_50752_).equals(resMap.get(resLoc)) && this.textureDataCache.getTexturedComponents().getOrDefault(secondaryResLoc, Blocks.f_50752_).equals(resMap.get(secondaryResLoc))) continue;
            update = true;
        }
        if (update) {
            this.textureDataCache = new MaterialTextureData(resMap);
            this.requestModelDataUpdate();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_(), 3);
            }
        }
    }

    @NotNull
    public ModelData getModelData() {
        if (!this.checkedAfterStartup && this.f_58857_ != null) {
            this.checkedAfterStartup = true;
            this.refreshTextureCache();
        }
        return ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)this.textureDataCache).build();
    }

    @NotNull
    public MaterialTextureData getTextureData() {
        return this.textureDataCache;
    }
}

