/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.core.quests.objectives.IBuildingUpgradeObjectiveTemplate;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BuildBuildingObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IBuildingUpgradeObjectiveTemplate {
    private final BuildingEntry buildingEntry;
    private final int nextObjective;
    private final boolean countExisting;
    private final int lvl;
    private final int qty;

    public BuildBuildingObjectiveTemplate(int target, BuildingEntry buildingEntry, int lvl, int qty, boolean countExisting, int nextObjective, List<Integer> rewards) {
        super(target, BuildBuildingObjectiveTemplate.buildDialogueTree(buildingEntry, qty, lvl, countExisting), rewards);
        this.lvl = lvl;
        this.qty = qty;
        this.countExisting = countExisting;
        this.nextObjective = nextObjective;
        this.buildingEntry = buildingEntry;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(BuildingEntry buildingEntry, int qty, int lvl, boolean countExisting) {
        MutableComponent text = countExisting ? (qty > 0 ? Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.existing", (Object[])new Object[]{lvl, qty, Component.m_237115_((String)buildingEntry.getTranslationKey())}) : Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.cumulative.existing", (Object[])new Object[]{lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())})) : (qty > 0 ? Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding", (Object[])new Object[]{qty, lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())}) : Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.cumulative", (Object[])new Object[]{lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())}));
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        BuildingEntry buildingEntry = (BuildingEntry)IMinecoloniesAPI.getInstance().getBuildingRegistry().getValue(new ResourceLocation(details.get("type").getAsString()));
        int level = details.get("lvl").getAsInt();
        int quantity = details.get("qty").getAsInt();
        boolean countExisting = details.get("count-existing").getAsBoolean();
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new BuildBuildingObjectiveTemplate(target, buildingEntry, level, quantity, countExisting, nextObj, BuildBuildingObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        IObjectiveInstance instance = this.createObjectiveInstance();
        if (this.countExisting) {
            this.checkInitialObjectiveProgress(colonyQuest, instance);
            if (instance.isFulfilled()) {
                return colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
            }
        }
        if (colonyQuest.getColony() instanceof Colony) {
            colonyQuest.getColony().getBuildingManager().trackBuildingLevelUp(this.buildingEntry, colonyQuest);
        }
        return instance;
    }

    private void checkInitialObjectiveProgress(IQuestInstance colonyQuest, IObjectiveInstance localInstance) {
        block4: {
            if (!(localInstance instanceof BuildingProgressInstance)) break block4;
            BuildingProgressInstance progressInstance = (BuildingProgressInstance)localInstance;
            if (this.qty > 0) {
                for (IBuilding building : colonyQuest.getColony().getBuildingManager().getBuildings().values()) {
                    if (building.getBuildingType() != this.buildingEntry || building.getBuildingLevel() < this.lvl) continue;
                    ++progressInstance.currentProgress;
                }
            } else {
                for (IBuilding building : colonyQuest.getColony().getBuildingManager().getBuildings().values()) {
                    if (building.getBuildingType() != this.buildingEntry) continue;
                    progressInstance.currentProgress += building.getBuildingLevel();
                }
            }
        }
    }

    private boolean advanceIfFinished(IQuestInstance colonyQuest) {
        BuildingProgressInstance progressInstance;
        IObjectiveInstance objective = colonyQuest.getCurrentObjectiveInstance();
        if (objective instanceof BuildingProgressInstance && (progressInstance = (BuildingProgressInstance)objective).isFulfilled()) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
            return true;
        }
        return false;
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            colonyQuest.getColony().getBuildingManager().stopTrackingBuildingLevelUp(this.buildingEntry, colonyQuest);
        }
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        IObjectiveInstance iObjectiveInstance = quest.getCurrentObjectiveInstance();
        if (iObjectiveInstance instanceof BuildingProgressInstance) {
            BuildingProgressInstance progress = (BuildingProgressInstance)iObjectiveInstance;
            if (this.qty > 0) {
                return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.progress", (Object[])new Object[]{Math.min(progress.currentProgress, this.qty), this.qty, Component.m_237115_((String)this.buildingEntry.getTranslationKey()).m_6270_(style)});
            }
            return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.progress.cumulative", (Object[])new Object[]{Math.min(progress.currentProgress, this.lvl), this.lvl, Component.m_237115_((String)this.buildingEntry.getTranslationKey()).m_6270_(style)});
        }
        return Component.m_237119_();
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        IColony iColony = colonyQuest.getColony();
        if (iColony instanceof Colony) {
            Colony colony = (Colony)iColony;
            if (!this.advanceIfFinished(colonyQuest)) {
                colony.getBuildingManager().trackBuildingLevelUp(this.buildingEntry, colonyQuest);
            }
        }
    }

    @Override
    @NotNull
    public IObjectiveInstance createObjectiveInstance() {
        return new BuildingProgressInstance(this, 0);
    }

    @Override
    public void onBuildingUpgrade(IObjectiveInstance progressData, IQuestInstance colonyQuest, int level) {
        if (progressData.isFulfilled()) {
            return;
        }
        if (!(progressData instanceof BuildingProgressInstance)) {
            return;
        }
        BuildingProgressInstance buildingProgressInstance = (BuildingProgressInstance)progressData;
        if (this.qty > 0) {
            if (level >= this.lvl) {
                ++buildingProgressInstance.currentProgress;
            }
        } else {
            ++buildingProgressInstance.currentProgress;
        }
        this.advanceIfFinished(colonyQuest);
    }

    private static class BuildingProgressInstance
    implements IObjectiveInstance {
        private final BuildBuildingObjectiveTemplate template;
        private int currentProgress;

        public BuildingProgressInstance(BuildBuildingObjectiveTemplate template, int currentProgress) {
            this.template = template;
            this.currentProgress = currentProgress;
        }

        @Override
        public boolean isFulfilled() {
            return this.template.qty > 0 ? this.currentProgress >= this.template.qty : this.currentProgress >= this.template.lvl;
        }

        @Override
        public int getMissingQuantity() {
            return 0;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("quantity", this.currentProgress);
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentProgress = nbt.m_128451_("quantity");
        }
    }
}

