/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.domumornamentum.block.AbstractPostBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.m_60734_() instanceof IMateriallyTexturedBlock && blockState.m_60734_() != ModBlocks.blockRack;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        if (world.m_8055_(pos).equals(blockState)) {
            world.m_7471_(pos, false);
            world.m_7731_(pos, blockState, 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                    BlockHitResult hitresult = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false);
                    blockState.m_60734_().m_6402_(world, pos, blockState, null, blockState.m_60734_().getCloneItemStack(blockState, (HitResult)new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false), (BlockGetter)world, pos, null));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!WorldUtil.setBlockState((LevelAccessor)world, pos, blockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                blockState.m_60734_().m_6402_(world, pos, blockState, null, blockState.m_60734_().getCloneItemStack(blockState, (HitResult)new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false), (BlockGetter)world, pos, null));
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (tileEntityData != null) {
            BlockPos blockpos = new BlockPos(tileEntityData.m_128451_("x"), tileEntityData.m_128451_("y"), tileEntityData.m_128451_("z"));
            BlockEntity tileEntity = BlockEntity.m_155241_((BlockPos)blockpos, (BlockState)blockState, (CompoundTag)tileEntityData);
            if (tileEntity == null) {
                return Collections.emptyList();
            }
            ItemStack item = BlockUtils.getMaterializedItemStack(null, (BlockEntity)tileEntity);
            if (blockState.m_60734_() instanceof DoorBlock) {
                item.m_41784_().m_128359_("type", ((DoorType)blockState.m_61143_((Property)DoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof FancyDoorBlock) {
                item.m_41784_().m_128359_("type", ((FancyDoorType)blockState.m_61143_((Property)FancyDoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof TrapdoorBlock) {
                item.m_41784_().m_128359_("type", ((TrapdoorType)blockState.m_61143_((Property)TrapdoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof FancyTrapdoorBlock) {
                item.m_41784_().m_128359_("type", ((FancyTrapdoorType)blockState.m_61143_((Property)FancyTrapdoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof PanelBlock) {
                item.m_41784_().m_128359_("type", ((TrapdoorType)blockState.m_61143_((Property)PanelBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof AbstractPostBlock) {
                item.m_41784_().m_128359_("type", ((PostType)blockState.m_61143_((Property)AbstractPostBlock.TYPE)).toString().toUpperCase());
            }
            itemList.add(item);
        }
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }
}

