/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.client.gui.WindowBuildDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public abstract class OpenBuildWindowMessage
implements IMessage {
    protected BlockPos pos;
    protected String path;
    protected String packName;
    protected Rotation rotation;
    protected boolean mirror;

    protected OpenBuildWindowMessage() {
    }

    protected OpenBuildWindowMessage(BlockPos pos, String packName, String path, Rotation rotation, Mirror mirror) {
        this.pos = pos;
        this.path = path;
        this.packName = packName;
        this.rotation = rotation;
        this.mirror = mirror != Mirror.NONE;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.path);
        buf.m_130070_(this.packName);
        buf.writeBoolean(this.mirror);
        buf.writeInt(this.rotation.ordinal());
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.path = buf.m_130136_(Short.MAX_VALUE);
        this.packName = buf.m_130136_(Short.MAX_VALUE);
        this.mirror = buf.readBoolean();
        this.rotation = Rotation.values()[buf.readInt()];
    }

    @Override
    @NotNull
    public final LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public final void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        new WindowBuildDecoration(this.pos, this.packName, this.path, this.rotation, this.mirror, this::createWorkOrderMessage).open();
    }

    protected abstract IMessage createWorkOrderMessage(BlockPos var1);
}

