/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.crafting.CustomRecipeManagerMessage;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import com.minecolonies.core.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.core.network.messages.client.CompostParticleMessage;
import com.minecolonies.core.network.messages.client.GlobalQuestSyncMessage;
import com.minecolonies.core.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.network.messages.client.OpenCantFoundColonyWarningMessage;
import com.minecolonies.core.network.messages.client.OpenColonyFoundingCovenantMessage;
import com.minecolonies.core.network.messages.client.OpenDecoBuildWindowMessage;
import com.minecolonies.core.network.messages.client.OpenDeleteAbandonColonyMessage;
import com.minecolonies.core.network.messages.client.OpenPlantationFieldBuildWindowMessage;
import com.minecolonies.core.network.messages.client.OpenReactivateColonyMessage;
import com.minecolonies.core.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import com.minecolonies.core.network.messages.client.SaveStructureNBTMessage;
import com.minecolonies.core.network.messages.client.SleepingParticleMessage;
import com.minecolonies.core.network.messages.client.StopMusicMessage;
import com.minecolonies.core.network.messages.client.StreamParticleEffectMessage;
import com.minecolonies.core.network.messages.client.SyncPathMessage;
import com.minecolonies.core.network.messages.client.SyncPathReachedMessage;
import com.minecolonies.core.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.core.network.messages.client.UpdateChunkRangeCapabilityMessage;
import com.minecolonies.core.network.messages.client.UpdateClientWithCompatibilityMessage;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyListMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewFieldsUpdateMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveCitizenMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewResearchManagerViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewWorkOrderMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyVisitorViewDataMessage;
import com.minecolonies.core.network.messages.client.colony.OpenBuildingUIMessage;
import com.minecolonies.core.network.messages.client.colony.PlayMusicAtPosMessage;
import com.minecolonies.core.network.messages.client.colony.PlaySoundForCitizenMessage;
import com.minecolonies.core.network.messages.server.ClickGuiButtonTriggerMessage;
import com.minecolonies.core.network.messages.server.CreateColonyMessage;
import com.minecolonies.core.network.messages.server.DecorationBuildRequestMessage;
import com.minecolonies.core.network.messages.server.DirectPlaceMessage;
import com.minecolonies.core.network.messages.server.GetColonyInfoMessage;
import com.minecolonies.core.network.messages.server.MarkStoryReadOnItem;
import com.minecolonies.core.network.messages.server.OpenGuiWindowTriggerMessage;
import com.minecolonies.core.network.messages.server.PickupBlockMessage;
import com.minecolonies.core.network.messages.server.PlantationFieldBuildRequestMessage;
import com.minecolonies.core.network.messages.server.ReactivateBuildingMessage;
import com.minecolonies.core.network.messages.server.RemoveFromRallyingListMessage;
import com.minecolonies.core.network.messages.server.ResourceScrollSaveWarehouseSnapshotMessage;
import com.minecolonies.core.network.messages.server.SwitchBuildingWithToolMessage;
import com.minecolonies.core.network.messages.server.SwitchRecipeCraftingTeachingMessage;
import com.minecolonies.core.network.messages.server.ToggleBannerRallyGuardsMessage;
import com.minecolonies.core.network.messages.server.TransferRecipeCraftingTeachingMessage;
import com.minecolonies.core.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyAbandonOwnMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyDeleteOwnMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyFlagChangeMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyNameStyleMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyStructureStyleMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyTextureStyleMessage;
import com.minecolonies.core.network.messages.server.colony.HireMercenaryMessage;
import com.minecolonies.core.network.messages.server.colony.HireSpiesMessage;
import com.minecolonies.core.network.messages.server.colony.InteractionClose;
import com.minecolonies.core.network.messages.server.colony.InteractionResponse;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.TeamColonyColorChangeMessage;
import com.minecolonies.core.network.messages.server.colony.TeleportToColonyMessage;
import com.minecolonies.core.network.messages.server.colony.TownHallRenameMessage;
import com.minecolonies.core.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.core.network.messages.server.colony.WorkOrderChangeMessage;
import com.minecolonies.core.network.messages.server.colony.building.AddMinimumStockToBuildingModuleMessage;
import com.minecolonies.core.network.messages.server.colony.building.AssignFilterableEntityMessage;
import com.minecolonies.core.network.messages.server.colony.building.AssignFilterableItemMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildPickUpMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildingSetStyleMessage;
import com.minecolonies.core.network.messages.server.colony.building.ChangeDeliveryPriorityMessage;
import com.minecolonies.core.network.messages.server.colony.building.CourierHiringModeMessage;
import com.minecolonies.core.network.messages.server.colony.building.ForcePickupMessage;
import com.minecolonies.core.network.messages.server.colony.building.GiveToolMessage;
import com.minecolonies.core.network.messages.server.colony.building.HireFireMessage;
import com.minecolonies.core.network.messages.server.colony.building.HutRenameMessage;
import com.minecolonies.core.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.core.network.messages.server.colony.building.OpenCraftingGUIMessage;
import com.minecolonies.core.network.messages.server.colony.building.QuarryHiringModeMessage;
import com.minecolonies.core.network.messages.server.colony.building.RecallCitizenHutMessage;
import com.minecolonies.core.network.messages.server.colony.building.RemoveMinimumStockFromBuildingModuleMessage;
import com.minecolonies.core.network.messages.server.colony.building.ResetFilterableItemMessage;
import com.minecolonies.core.network.messages.server.colony.building.TransferItemsRequestMessage;
import com.minecolonies.core.network.messages.server.colony.building.TriggerSettingMessage;
import com.minecolonies.core.network.messages.server.colony.building.builder.BuilderSelectWorkOrderMessage;
import com.minecolonies.core.network.messages.server.colony.building.enchanter.EnchanterWorkerSetMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.AssignFieldMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.AssignmentModeMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldPlotResizeMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldRegistrationMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldUpdateSeedMessage;
import com.minecolonies.core.network.messages.server.colony.building.guard.GuardSetMinePosMessage;
import com.minecolonies.core.network.messages.server.colony.building.home.AssignUnassignMessage;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerRepairLevelMessage;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import com.minecolonies.core.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import com.minecolonies.core.network.messages.server.colony.building.university.TryResearchMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.RecallCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ToggleRecipeMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.AdjustSkillCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.PauseCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.RecallSingleCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.RestartCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import com.minecolonies.core.network.messages.splitting.SplitPacketMessage;
import com.minecolonies.core.research.GlobalResearchTreeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkChannel {
    private final SimpleChannel rawChannel;
    private final Map<Integer, NetworkingMessageEntry<?>> messagesTypes = Maps.newHashMap();
    private final Map<Class<? extends IMessage>, Integer> messageTypeToIdMap = Maps.newHashMap();
    private final Cache<Integer, Map<Integer, byte[]>> messageCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(8).build();
    private final AtomicInteger messageCounter = new AtomicInteger();

    public NetworkChannel(String channelName) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById("minecolonies").get()).getModInfo().getVersion().toString();
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("minecolonies", channelName), () -> modVersion, str -> str.equals(modVersion), str -> str.equals(modVersion));
    }

    public void registerCommonMessages() {
        this.setupInternalMessages();
        int idx = 0;
        this.registerMessage(++idx, ColonyViewMessage.class, ColonyViewMessage::new);
        this.registerMessage(++idx, ColonyViewCitizenViewMessage.class, ColonyViewCitizenViewMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveCitizenMessage.class, ColonyViewRemoveCitizenMessage::new);
        this.registerMessage(++idx, ColonyViewBuildingViewMessage.class, ColonyViewBuildingViewMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveBuildingMessage.class, ColonyViewRemoveBuildingMessage::new);
        this.registerMessage(++idx, ColonyViewFieldsUpdateMessage.class, ColonyViewFieldsUpdateMessage::new);
        this.registerMessage(++idx, PermissionsMessage.View.class, PermissionsMessage.View::new);
        this.registerMessage(++idx, ColonyViewWorkOrderMessage.class, ColonyViewWorkOrderMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveWorkOrderMessage.class, ColonyViewRemoveWorkOrderMessage::new);
        this.registerMessage(++idx, UpdateChunkCapabilityMessage.class, UpdateChunkCapabilityMessage::new);
        this.registerMessage(++idx, ColonyViewResearchManagerViewMessage.class, ColonyViewResearchManagerViewMessage::new);
        this.registerMessage(++idx, PermissionsMessage.Permission.class, PermissionsMessage.Permission::new);
        this.registerMessage(++idx, PermissionsMessage.AddPlayer.class, PermissionsMessage.AddPlayer::new);
        this.registerMessage(++idx, PermissionsMessage.RemovePlayer.class, PermissionsMessage.RemovePlayer::new);
        this.registerMessage(++idx, PermissionsMessage.ChangePlayerRank.class, PermissionsMessage.ChangePlayerRank::new);
        this.registerMessage(++idx, PermissionsMessage.AddPlayerOrFakePlayer.class, PermissionsMessage.AddPlayerOrFakePlayer::new);
        this.registerMessage(++idx, PermissionsMessage.AddRank.class, PermissionsMessage.AddRank::new);
        this.registerMessage(++idx, PermissionsMessage.RemoveRank.class, PermissionsMessage.RemoveRank::new);
        this.registerMessage(++idx, PermissionsMessage.EditRankType.class, PermissionsMessage.EditRankType::new);
        this.registerMessage(++idx, PermissionsMessage.SetSubscriber.class, PermissionsMessage.SetSubscriber::new);
        this.registerMessage(++idx, BuildRequestMessage.class, BuildRequestMessage::new);
        this.registerMessage(++idx, OpenInventoryMessage.class, OpenInventoryMessage::new);
        this.registerMessage(++idx, TownHallRenameMessage.class, TownHallRenameMessage::new);
        this.registerMessage(++idx, MinerSetLevelMessage.class, MinerSetLevelMessage::new);
        this.registerMessage(++idx, RecallCitizenMessage.class, RecallCitizenMessage::new);
        this.registerMessage(++idx, HireFireMessage.class, HireFireMessage::new);
        this.registerMessage(++idx, WorkOrderChangeMessage.class, WorkOrderChangeMessage::new);
        this.registerMessage(++idx, AssignFieldMessage.class, AssignFieldMessage::new);
        this.registerMessage(++idx, AssignmentModeMessage.class, AssignmentModeMessage::new);
        this.registerMessage(++idx, GuardSetMinePosMessage.class, GuardSetMinePosMessage::new);
        this.registerMessage(++idx, RecallCitizenHutMessage.class, RecallCitizenHutMessage::new);
        this.registerMessage(++idx, TransferItemsRequestMessage.class, TransferItemsRequestMessage::new);
        this.registerMessage(++idx, MarkBuildingDirtyMessage.class, MarkBuildingDirtyMessage::new);
        this.registerMessage(++idx, ChangeFreeToInteractBlockMessage.class, ChangeFreeToInteractBlockMessage::new);
        this.registerMessage(++idx, CreateColonyMessage.class, CreateColonyMessage::new);
        this.registerMessage(++idx, ColonyDeleteOwnMessage.class, ColonyDeleteOwnMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveMessage.class, ColonyViewRemoveMessage::new);
        this.registerMessage(++idx, GiveToolMessage.class, GiveToolMessage::new);
        this.registerMessage(++idx, ColonyAbandonOwnMessage.class, ColonyAbandonOwnMessage::new);
        this.registerMessage(++idx, AssignUnassignMessage.class, AssignUnassignMessage::new);
        this.registerMessage(++idx, OpenCraftingGUIMessage.class, OpenCraftingGUIMessage::new);
        this.registerMessage(++idx, AddRemoveRecipeMessage.class, AddRemoveRecipeMessage::new);
        this.registerMessage(++idx, ChangeRecipePriorityMessage.class, ChangeRecipePriorityMessage::new);
        this.registerMessage(++idx, ChangeDeliveryPriorityMessage.class, ChangeDeliveryPriorityMessage::new);
        this.registerMessage(++idx, ForcePickupMessage.class, ForcePickupMessage::new);
        this.registerMessage(++idx, UpgradeWarehouseMessage.class, UpgradeWarehouseMessage::new);
        this.registerMessage(++idx, TransferItemsToCitizenRequestMessage.class, TransferItemsToCitizenRequestMessage::new);
        this.registerMessage(++idx, UpdateRequestStateMessage.class, UpdateRequestStateMessage::new);
        this.registerMessage(++idx, BuildingSetStyleMessage.class, BuildingSetStyleMessage::new);
        this.registerMessage(++idx, RecallSingleCitizenMessage.class, RecallSingleCitizenMessage::new);
        this.registerMessage(++idx, AssignFilterableItemMessage.class, AssignFilterableItemMessage::new);
        this.registerMessage(++idx, TeamColonyColorChangeMessage.class, TeamColonyColorChangeMessage::new);
        this.registerMessage(++idx, ColonyFlagChangeMessage.class, ColonyFlagChangeMessage::new);
        this.registerMessage(++idx, ColonyStructureStyleMessage.class, ColonyStructureStyleMessage::new);
        this.registerMessage(++idx, PauseCitizenMessage.class, PauseCitizenMessage::new);
        this.registerMessage(++idx, RestartCitizenMessage.class, RestartCitizenMessage::new);
        this.registerMessage(++idx, SortWarehouseMessage.class, SortWarehouseMessage::new);
        this.registerMessage(++idx, PostBoxRequestMessage.class, PostBoxRequestMessage::new);
        this.registerMessage(++idx, HireMercenaryMessage.class, HireMercenaryMessage::new);
        this.registerMessage(++idx, HutRenameMessage.class, HutRenameMessage::new);
        this.registerMessage(++idx, BuildingHiringModeMessage.class, BuildingHiringModeMessage::new);
        this.registerMessage(++idx, DecorationBuildRequestMessage.class, DecorationBuildRequestMessage::new);
        this.registerMessage(++idx, DirectPlaceMessage.class, DirectPlaceMessage::new);
        this.registerMessage(++idx, TeleportToColonyMessage.class, TeleportToColonyMessage::new);
        this.registerMessage(++idx, EnchanterWorkerSetMessage.class, EnchanterWorkerSetMessage::new);
        this.registerMessage(++idx, InteractionResponse.class, InteractionResponse::new);
        this.registerMessage(++idx, TryResearchMessage.class, TryResearchMessage::new);
        this.registerMessage(++idx, HireSpiesMessage.class, HireSpiesMessage::new);
        this.registerMessage(++idx, AddMinimumStockToBuildingModuleMessage.class, AddMinimumStockToBuildingModuleMessage::new);
        this.registerMessage(++idx, RemoveMinimumStockFromBuildingModuleMessage.class, RemoveMinimumStockFromBuildingModuleMessage::new);
        this.registerMessage(++idx, FarmFieldPlotResizeMessage.class, FarmFieldPlotResizeMessage::new);
        this.registerMessage(++idx, FarmFieldRegistrationMessage.class, FarmFieldRegistrationMessage::new);
        this.registerMessage(++idx, FarmFieldUpdateSeedMessage.class, FarmFieldUpdateSeedMessage::new);
        this.registerMessage(++idx, AdjustSkillCitizenMessage.class, AdjustSkillCitizenMessage::new);
        this.registerMessage(++idx, BuilderSelectWorkOrderMessage.class, BuilderSelectWorkOrderMessage::new);
        this.registerMessage(++idx, TriggerSettingMessage.class, TriggerSettingMessage::new);
        this.registerMessage(++idx, AssignFilterableEntityMessage.class, AssignFilterableEntityMessage::new);
        this.registerMessage(++idx, BuildPickUpMessage.class, BuildPickUpMessage::new);
        this.registerMessage(++idx, SwitchBuildingWithToolMessage.class, SwitchBuildingWithToolMessage::new);
        this.registerMessage(++idx, ColonyTextureStyleMessage.class, ColonyTextureStyleMessage::new);
        this.registerMessage(++idx, MinerRepairLevelMessage.class, MinerRepairLevelMessage::new);
        this.registerMessage(++idx, PlantationFieldBuildRequestMessage.class, PlantationFieldBuildRequestMessage::new);
        this.registerMessage(++idx, ResetFilterableItemMessage.class, ResetFilterableItemMessage::new);
        this.registerMessage(++idx, CourierHiringModeMessage.class, CourierHiringModeMessage::new);
        this.registerMessage(++idx, QuarryHiringModeMessage.class, QuarryHiringModeMessage::new);
        this.registerMessage(++idx, ToggleRecipeMessage.class, ToggleRecipeMessage::new);
        this.registerMessage(++idx, ColonyNameStyleMessage.class, ColonyNameStyleMessage::new);
        this.registerMessage(++idx, InteractionClose.class, InteractionClose::new);
        this.registerMessage(++idx, GetColonyInfoMessage.class, GetColonyInfoMessage::new);
        this.registerMessage(++idx, PickupBlockMessage.class, PickupBlockMessage::new);
        this.registerMessage(++idx, MarkStoryReadOnItem.class, MarkStoryReadOnItem::new);
        this.registerMessage(++idx, BlockParticleEffectMessage.class, BlockParticleEffectMessage::new);
        this.registerMessage(++idx, CompostParticleMessage.class, CompostParticleMessage::new);
        this.registerMessage(++idx, ItemParticleEffectMessage.class, ItemParticleEffectMessage::new);
        this.registerMessage(++idx, LocalizedParticleEffectMessage.class, LocalizedParticleEffectMessage::new);
        this.registerMessage(++idx, UpdateChunkRangeCapabilityMessage.class, UpdateChunkRangeCapabilityMessage::new);
        this.registerMessage(++idx, OpenSuggestionWindowMessage.class, OpenSuggestionWindowMessage::new);
        this.registerMessage(++idx, UpdateClientWithCompatibilityMessage.class, UpdateClientWithCompatibilityMessage::new);
        this.registerMessage(++idx, CircleParticleEffectMessage.class, CircleParticleEffectMessage::new);
        this.registerMessage(++idx, StreamParticleEffectMessage.class, StreamParticleEffectMessage::new);
        this.registerMessage(++idx, SleepingParticleMessage.class, SleepingParticleMessage::new);
        this.registerMessage(++idx, VanillaParticleMessage.class, VanillaParticleMessage::new);
        this.registerMessage(++idx, StopMusicMessage.class, StopMusicMessage::new);
        this.registerMessage(++idx, PlayAudioMessage.class, PlayAudioMessage::new);
        this.registerMessage(++idx, PlayMusicAtPosMessage.class, PlayMusicAtPosMessage::new);
        this.registerMessage(++idx, ColonyVisitorViewDataMessage.class, ColonyVisitorViewDataMessage::new);
        this.registerMessage(++idx, SyncPathMessage.class, SyncPathMessage::new);
        this.registerMessage(++idx, SyncPathReachedMessage.class, SyncPathReachedMessage::new);
        this.registerMessage(++idx, ReactivateBuildingMessage.class, ReactivateBuildingMessage::new);
        this.registerMessage(++idx, PlaySoundForCitizenMessage.class, PlaySoundForCitizenMessage::new);
        this.registerMessage(++idx, OpenDecoBuildWindowMessage.class, OpenDecoBuildWindowMessage::new);
        this.registerMessage(++idx, OpenPlantationFieldBuildWindowMessage.class, OpenPlantationFieldBuildWindowMessage::new);
        this.registerMessage(++idx, SaveStructureNBTMessage.class, SaveStructureNBTMessage::new);
        this.registerMessage(++idx, GlobalQuestSyncMessage.class, GlobalQuestSyncMessage::new);
        this.registerMessage(++idx, OpenColonyFoundingCovenantMessage.class, OpenColonyFoundingCovenantMessage::new);
        this.registerMessage(++idx, OpenBuildingUIMessage.class, OpenBuildingUIMessage::new);
        this.registerMessage(++idx, OpenCantFoundColonyWarningMessage.class, OpenCantFoundColonyWarningMessage::new);
        this.registerMessage(++idx, OpenDeleteAbandonColonyMessage.class, OpenDeleteAbandonColonyMessage::new);
        this.registerMessage(++idx, OpenReactivateColonyMessage.class, OpenReactivateColonyMessage::new);
        this.registerMessage(++idx, TransferRecipeCraftingTeachingMessage.class, TransferRecipeCraftingTeachingMessage::new);
        this.registerMessage(++idx, OpenGuiWindowTriggerMessage.class, OpenGuiWindowTriggerMessage::new);
        this.registerMessage(++idx, ClickGuiButtonTriggerMessage.class, ClickGuiButtonTriggerMessage::new);
        this.registerMessage(++idx, RemoveFromRallyingListMessage.class, RemoveFromRallyingListMessage::new);
        this.registerMessage(++idx, ToggleBannerRallyGuardsMessage.class, ToggleBannerRallyGuardsMessage::new);
        this.registerMessage(++idx, GlobalResearchTreeMessage.class, GlobalResearchTreeMessage::new);
        this.registerMessage(++idx, CustomRecipeManagerMessage.class, CustomRecipeManagerMessage::new);
        this.registerMessage(++idx, ColonyListMessage.class, ColonyListMessage::new);
        this.registerMessage(++idx, ResourceScrollSaveWarehouseSnapshotMessage.class, ResourceScrollSaveWarehouseSnapshotMessage::new);
        this.registerMessage(++idx, SwitchRecipeCraftingTeachingMessage.class, SwitchRecipeCraftingTeachingMessage::new);
    }

    private void setupInternalMessages() {
        this.rawChannel.registerMessage(0, SplitPacketMessage.class, IMessage::toBytes, buf -> {
            SplitPacketMessage msg = new SplitPacketMessage();
            msg.fromBytes((FriendlyByteBuf)buf);
            return msg;
        }, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT));
        });
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Supplier<MSG> msgCreator) {
        this.messagesTypes.put(id, new NetworkingMessageEntry<MSG>(msgCreator));
        this.messageTypeToIdMap.put(msgClazz, id);
    }

    public void sendToServer(IMessage msg) {
        this.handleSplitting(msg, arg_0 -> ((SimpleChannel)this.rawChannel).sendToServer(arg_0));
    }

    public void sendToPlayer(IMessage msg, ServerPlayer player) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), s));
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToDimension(IMessage msg, ResourceLocation dim) {
        this.rawChannel.send(PacketDistributor.DIMENSION.with(() -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim)), (Object)msg);
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), s));
    }

    public void sendToEveryone(IMessage msg) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.ALL.noArg(), s));
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), s));
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), s));
    }

    public void sendToTrackingChunk(IMessage msg, LevelChunk chunk) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), s));
    }

    private void handleSplitting(IMessage msg, Consumer<IMessage> splitMessageConsumer) {
        int extra;
        int messageId = this.messageTypeToIdMap.getOrDefault(msg.getClass(), -1);
        if (messageId == -1) {
            throw new IllegalArgumentException("The message is unknown to this channel!");
        }
        ByteBuf buffer = Unpooled.buffer();
        FriendlyByteBuf innerFriendlyByteBuf = new FriendlyByteBuf(buffer);
        msg.toBytes(innerFriendlyByteBuf);
        byte[] data = buffer.array();
        buffer.release();
        int max_packet_size = 943718;
        int packetIndex = 0;
        int comId = this.messageCounter.getAndIncrement();
        for (int currentIndex = 0; currentIndex < data.length; currentIndex += extra) {
            this.getMessagesTypes().get(messageId).onSplitting(packetIndex);
            extra = Math.min(943718, data.length - currentIndex);
            byte[] subPacketData = Arrays.copyOfRange(data, currentIndex, currentIndex + extra);
            SplitPacketMessage splitPacketMessage = new SplitPacketMessage(comId, packetIndex++, currentIndex + extra >= data.length, messageId, subPacketData);
            splitMessageConsumer.accept(splitPacketMessage);
        }
    }

    public Cache<Integer, Map<Integer, byte[]>> getMessageCache() {
        return this.messageCache;
    }

    public Map<Integer, NetworkingMessageEntry<?>> getMessagesTypes() {
        return this.messagesTypes;
    }

    public static final class NetworkingMessageEntry<MSG extends IMessage> {
        private final AtomicBoolean hasWarned = new AtomicBoolean(true);
        private final Supplier<MSG> creator;

        private NetworkingMessageEntry(Supplier<MSG> creator) {
            this.creator = creator;
        }

        public Supplier<MSG> getCreator() {
            return this.creator;
        }

        public void onSplitting(int packetIndex) {
            if (packetIndex != 1) {
                return;
            }
            if (this.hasWarned.getAndSet(false)) {
                Log.getLogger().warn("Splitting message: " + ((IMessage)this.creator.get()).getClass() + " it is too big to send normally. This message is only printed once");
            }
        }
    }
}

