/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyTP
extends AbstractItemScroll {
    public ItemScrollColonyTP(Item.Properties properties) {
        super("scroll_tp", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.f_46441_.m_188503_(10) == 0) {
            player.m_5661_((Component)Component.m_237115_((String)("minecolonies.scroll.failed" + (world.f_46441_.m_188503_(10) + 1))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            BlockPos pos = null;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pos = BlockPosUtil.findAround(world, player.m_20183_().m_5484_(dir, 10), 5, 5, (predWorld, predPos) -> predWorld.m_8055_(predPos).m_60795_() && predWorld.m_8055_(predPos.m_7494_()).m_60795_());
                if (pos == null) continue;
                break;
            }
            if (pos != null) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 140));
                player.m_8999_((ServerLevel)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), player.m_146908_(), player.m_146909_());
            }
            SoundUtils.playSoundForPlayer(player, SoundEvents.f_11735_, 0.4f, 1.0f);
        } else {
            this.doTeleport(player, this.getColony(itemStack), itemStack);
            SoundUtils.playSoundForPlayer(player, SoundEvents.f_11887_, 0.6f, 1.0f);
        }
        itemStack.m_41774_(1);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayer player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void m_5929_(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.f_46443_ && worldIn.m_46467_() % 5L == 0L) {
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleTypes.f_123751_), (Entity)entity);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleTypes.f_123751_), (ServerPlayer)entity);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.m_237115_((String)"item.minecolonies.scroll_tp.tip");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        MutableComponent colonyDesc = Component.m_237115_((String)"item.minecolonies.scroll.colony.none");
        if (stack.m_41784_().m_128441_("desc")) {
            colonyDesc = Component.m_237113_((String)stack.m_41784_().m_128461_("desc"));
        } else {
            IColony colony = this.getColonyView(stack);
            if (colony != null) {
                colonyDesc = Component.m_237113_((String)colony.getName());
                stack.m_41784_().m_128359_("desc", colony.getName());
            }
        }
        MutableComponent guiHint2 = Component.m_237110_((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

