/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemScroll
extends AbstractItemMinecolonies {
    public static final String TAG_COLONY_DIM = "colony_dim";
    public static final String TAG_BUILDING_POS = "building_pos";
    public static final int FAIL_RESPONSES_TOTAL = 10;

    public AbstractItemScroll(String name, Item.Properties properties) {
        super(name, properties);
    }

    public int m_8105_(ItemStack itemStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public ItemStack m_5922_(ItemStack itemStack, Level world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof ServerPlayer) || world.f_46443_) {
            return itemStack;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        if (!this.needsColony()) {
            return this.onItemUseSuccess(itemStack, world, player);
        }
        IColony colony = this.getColony(itemStack);
        if (colony == null) {
            player.m_5661_((Component)Component.m_237115_((String)"minecolonies.scroll.needcolony"), true);
            return itemStack;
        }
        if (!colony.getPermissions().hasPermission((Player)player, Action.RIGHTCLICK_BLOCK)) {
            MessageUtils.format("minecolonies.scroll.nopermission", new Object[0]).sendTo(new Player[]{player});
            return itemStack;
        }
        return this.onItemUseSuccess(itemStack, world, player);
    }

    protected abstract ItemStack onItemUseSuccess(ItemStack var1, Level var2, ServerPlayer var3);

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_ || !ctx.m_43723_().m_6144_() || !this.needsColony()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_());
        ItemStack scroll = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = AbstractItemScroll.checkForCompound(scroll);
        if (te instanceof TileEntityColonyBuilding) {
            compound.m_128405_("colony", ((AbstractTileEntityColonyBuilding)te).getColonyId());
            compound.m_128359_(TAG_COLONY_DIM, ((AbstractTileEntityColonyBuilding)te).getColony().getWorld().m_46472_().m_135782_().toString());
            BlockPosUtil.write(compound, TAG_BUILDING_POS, ctx.m_8083_());
            MessageUtils.format("minecolonies.scroll.registered", ((AbstractTileEntityColonyBuilding)te).getColony().getName()).sendTo(ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract boolean needsColony();

    private static CompoundTag checkForCompound(ItemStack item) {
        if (!item.m_41782_()) {
            item.m_41751_(new CompoundTag());
        }
        return item.m_41783_();
    }

    protected IColony getColony(ItemStack stack) {
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_("colony") && stack.m_41783_().m_128441_(TAG_COLONY_DIM))) {
            return null;
        }
        return IColonyManager.getInstance().getColonyByDimension(stack.m_41783_().m_128451_("colony"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41783_().m_128461_(TAG_COLONY_DIM))));
    }

    protected IColony getColonyView(ItemStack stack) {
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_("colony") && stack.m_41783_().m_128441_(TAG_COLONY_DIM))) {
            return null;
        }
        return IColonyManager.getInstance().getColonyView(stack.m_41783_().m_128451_("colony"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41783_().m_128461_(TAG_COLONY_DIM))));
    }
}

