/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.core.generation.SoundsJson;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultSoundProvider
implements DataProvider {
    private final PackOutput packOutput;
    private JsonObject sounds;

    public DefaultSoundProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        this.sounds = new JsonObject();
        File soundFolder = this.packOutput.m_245114_().getParent().getParent().getParent().resolve("main").resolve("resources").resolve("assets").resolve("minecolonies").resolve("sounds").resolve("mob").resolve("citizen").toFile();
        ArrayList<ResourceLocation> mainTypes = new ArrayList<ResourceLocation>(ModJobs.getJobs());
        mainTypes.remove(ModJobs.placeHolder.getId());
        mainTypes.add(new ResourceLocation("minecolonies", "unemployed"));
        mainTypes.add(new ResourceLocation("minecolonies", "visitor"));
        if (soundFolder.isDirectory()) {
            File[] list;
            for (File file : list = soundFolder.listFiles()) {
                String name = file.getName();
                if (!file.isDirectory()) continue;
                ArrayList<String> soundList = new ArrayList<String>();
                File[] subList = file.listFiles();
                for (File soundFile : subList) {
                    String soundName = soundFile.getName();
                    soundList.add("minecolonies:mob/citizen/" + name + "/" + soundName.replace(".ogg", ""));
                }
                for (ResourceLocation job : mainTypes) {
                    for (EventType event : EventType.values()) {
                        this.sounds.add("citizen." + job.m_135815_() + "." + name + "." + event.getId(), (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), soundList));
                    }
                }
            }
        }
        ArrayList<String> childSounds = new ArrayList<String>();
        childSounds.add("minecolonies:mob/citizen/child/laugh1");
        childSounds.add("minecolonies:mob/citizen/child/laugh2");
        for (EventType eventType : EventType.values()) {
            this.sounds.add("mob.child.male." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), childSounds));
            this.sounds.add("mob.child.female." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), childSounds));
        }
        for (RaiderType raiderType : RaiderType.values()) {
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".death", (JsonElement)SoundsJson.createSoundJson("hostile", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/barbarian/death")));
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".say", (JsonElement)SoundsJson.createSoundJson("hostile", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/barbarian/say")));
            this.sounds.add("mob." + raiderType.name().toLowerCase(Locale.US) + ".hurt", (JsonElement)SoundsJson.createSoundJson("hostile", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/barbarian/hurt1", (Object)"minecolonies:mob/barbarian/hurt2", (Object)"minecolonies:mob/barbarian/hurt3", (Object)"minecolonies:mob/barbarian/hurt4")));
        }
        this.sounds.add("mob.citizen.snore", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/citizen/snore")));
        JsonObject jsonObject = this.getDefaultProperties();
        jsonObject.addProperty("attenuation_distance", (Number)23);
        jsonObject.addProperty("stream", Boolean.valueOf(true));
        jsonObject.addProperty("comment", "Credits to Darren Curtis - Fireside Tales");
        this.sounds.add("tile.tavern.tavern_theme", (JsonElement)SoundsJson.createSoundJson("music", jsonObject, (List<String>)ImmutableList.of((Object)"minecolonies:tile/tavern/tavern_theme")));
        this.sounds.add("mob.mercenary.attack", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/attack/attack1", (Object)"minecolonies:mob/mercenary/attack/attack2", (Object)"minecolonies:mob/mercenary/attack/attack3", (Object)"minecolonies:mob/mercenary/attack/attack4")));
        this.sounds.add("mob.mercenary.celebrate", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/celebrate/celebrate1")));
        this.sounds.add("mob.mercenary.die", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/die/death1", (Object)"minecolonies:mob/mercenary/die/death2")));
        this.sounds.add("mob.mercenary.hurt", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/hurt/hurt1", (Object)"minecolonies:mob/mercenary/hurt/hurt2", (Object)"minecolonies:mob/mercenary/hurt/hurt3")));
        this.sounds.add("mob.mercenary.say", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/say/say1", (Object)"minecolonies:mob/mercenary/say/say2", (Object)"minecolonies:mob/mercenary/say/say3")));
        this.sounds.add("mob.mercenary.step", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:mob/mercenary/step/step1", (Object)"minecolonies:mob/mercenary/step/step2", (Object)"minecolonies:mob/mercenary/step/step3", (Object)"minecolonies:mob/mercenary/step/step4")));
        this.sounds.add("tile.sawmill.saw", (JsonElement)SoundsJson.createSoundJson("neutral", this.getDefaultProperties(), (List<String>)ImmutableList.of((Object)"minecolonies:tile/sawmill/saw")));
        this.add("record", false, "raid.raid_alert", "raid.raid_alert_early", "raid.raid_won", "raid.raid_won_early");
        this.add("music", true, "raid.desert.desert_raid", "raid.desert.desert_raid_warning", "raid.desert.desert_raid_victory", "raid.amazon.amazon_raid");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.sounds, (Path)this.getPath());
    }

    protected Path getPath() {
        return this.packOutput.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("minecolonies").resolve("sounds.json");
    }

    @NotNull
    public String m_6055_() {
        return "Default Sound Json Provider";
    }

    private JsonObject getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("stream", Boolean.valueOf(false));
        return properties;
    }

    private void add(String category, boolean stream, String ... ids) {
        for (String id : ids) {
            JsonObject obj = new JsonObject();
            obj.addProperty("stream", Boolean.valueOf(stream));
            this.sounds.add(id, (JsonElement)SoundsJson.createSoundJson(category, obj, (List<String>)ImmutableList.of((Object)("minecolonies:" + id.replace(".", "/")))));
        }
    }
}

