/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomRecipeProvider
implements DataProvider {
    private final PackOutput packOutput;

    public CustomRecipeProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "crafterrecipes");
        HashMap futures = new HashMap();
        this.registerRecipes(recipe -> {
            if (futures.containsKey(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            futures.put(recipe.m_6445_(), DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)pathProvider.m_245731_(recipe.m_6445_())));
        });
        return CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0]));
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    public static class CustomRecipeBuilder {
        private final JsonObject json = new JsonObject();
        private final ResourceLocation id;
        private Block intermediate = Blocks.f_50016_;

        private CustomRecipeBuilder(String crafter, String module, String id) {
            this.json.addProperty("type", "recipe");
            this.json.addProperty("crafter", crafter + "_" + module);
            this.id = new ResourceLocation("minecolonies", crafter + "/" + id);
        }

        @NotNull
        public static CustomRecipeBuilder create(String crafter, String module, String id) {
            return new CustomRecipeBuilder(crafter, module, id);
        }

        @NotNull
        public CustomRecipeBuilder inputs(@NotNull List<ItemStorage> inputs) {
            this.json.add("inputs", (JsonElement)this.storageAsJson(inputs));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder result(@NotNull ItemStack result) {
            JsonObject jsonItemStack = this.stackAsJson(result);
            this.json.addProperty("result", jsonItemStack.get("item").getAsString());
            if (jsonItemStack.has("count")) {
                this.json.add("count", jsonItemStack.get("count"));
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder lootTable(@NotNull ResourceLocation lootTable) {
            this.json.addProperty("loot-table", lootTable.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder requiredTool(@NotNull IToolType toolType) {
            if (toolType != ToolType.NONE) {
                this.json.addProperty("tool", toolType.getName());
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder secondaryOutputs(@NotNull List<ItemStack> secondary) {
            this.json.add("additional-output", (JsonElement)this.stackAsJson(secondary));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder alternateOutputs(@NotNull List<ItemStack> alternates) {
            this.json.add("alternate-output", (JsonElement)this.stackAsJson(alternates));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder intermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minResearchId(@NotNull ResourceLocation researchId) {
            JsonElement ids = this.json.get("research-id");
            if (ids == null) {
                this.json.addProperty("research-id", researchId.toString());
            } else if (ids.isJsonArray()) {
                ids.getAsJsonArray().add(researchId.toString());
            } else {
                JsonArray array = new JsonArray();
                array.add(ids.getAsString());
                array.add(researchId.toString());
                this.json.remove("research-id");
                this.json.add("research-id", (JsonElement)array);
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxResearchId(@NotNull ResourceLocation researchId) {
            JsonElement ids = this.json.get("not-research-id");
            if (ids == null) {
                this.json.addProperty("not-research-id", researchId.toString());
            } else if (ids.isJsonArray()) {
                ids.getAsJsonArray().add(researchId.toString());
            } else {
                JsonArray array = new JsonArray();
                array.add(ids.getAsString());
                array.add(researchId.toString());
                this.json.remove("not-research-id");
                this.json.add("not-research-id", (JsonElement)array);
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minBuildingLevel(int level) {
            this.json.addProperty("min-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxBuildingLevel(int level) {
            this.json.addProperty("max-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder mustExist(boolean value) {
            this.json.addProperty("must-exist", Boolean.valueOf(value));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder showTooltip(boolean value) {
            this.json.addProperty("show-tooltip", Boolean.valueOf(value));
            return this;
        }

        public void build(@NotNull Consumer<FinishedRecipe> consumer) {
            this.json.addProperty("intermediate", ForgeRegistries.BLOCKS.getKey((Object)this.intermediate).toString());
            consumer.accept(new Result(this.json, this.id));
        }

        @NotNull
        private JsonObject stackAsJson(ItemStack stack) {
            JsonObject jsonItemStack = new JsonObject();
            Object name = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
            if (stack.m_41782_() && !stack.m_41763_()) {
                name = (String)name + stack.m_41783_().toString();
            }
            jsonItemStack.addProperty("item", (String)name);
            if (stack.m_41613_() != 1) {
                jsonItemStack.addProperty("count", (Number)stack.m_41613_());
            }
            return jsonItemStack;
        }

        @NotNull
        private JsonArray stackAsJson(List<ItemStack> itemStacks) {
            JsonArray jsonItemStacks = new JsonArray();
            for (ItemStack itemStack : itemStacks) {
                jsonItemStacks.add((JsonElement)this.stackAsJson(itemStack));
            }
            return jsonItemStacks;
        }

        @NotNull
        private JsonArray storageAsJson(List<ItemStorage> itemStorages) {
            JsonArray jsonItemStorages = new JsonArray();
            for (ItemStorage itemStorage : itemStorages) {
                JsonObject jsonItemStorage = this.stackAsJson(itemStorage.getItemStack());
                if (itemStorage.getAmount() == 1) {
                    jsonItemStorage.remove("count");
                } else {
                    jsonItemStorage.addProperty("count", (Number)itemStorage.getAmount());
                }
                if (itemStorage.ignoreNBT()) {
                    jsonItemStorage.addProperty("matchType", "ignore");
                }
                jsonItemStorages.add((JsonElement)jsonItemStorage);
            }
            return jsonItemStorages;
        }

        private static class Result
        implements FinishedRecipe {
            final JsonObject json;
            final ResourceLocation id;

            public Result(JsonObject json, ResourceLocation id) {
                this.json = json;
                this.id = id;
            }

            @NotNull
            public JsonObject m_125966_() {
                return this.json;
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            public void m_7917_(@NotNull JsonObject json) {
            }

            public RecipeSerializer<?> m_6637_() {
                return null;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

