/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.client.gui.WindowBuildingBrowser;
import com.minecolonies.core.client.render.worldevent.ColonyBorderRenderer;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import com.minecolonies.core.util.SchemAnalyzerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Lazy<Map<String, BuildingEntry>> crafterToBuilding = Lazy.of(ClientEventHandler::buildCrafterToBuildingMap);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderLevelStageEvent event) {
        WorldEventContext.INSTANCE.renderWorldLastEvent(event);
    }

    @SubscribeEvent
    public static void onPlayerLogout(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        ColonyBorderRenderer.cleanup();
        WindowBuildingBrowser.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ResourceLocation soundLocation = event.getSound().m_7904_();
        if (!((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().citizenVoices.get()).booleanValue() && soundLocation.m_135827_().equals("minecolonies") && soundLocation.m_135815_().startsWith("citizen.")) {
            event.setSound(null);
        }
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        IColony colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColony(event.getEntity().f_19853_, event.getEntity().m_20183_());
        if (colony == null) {
            colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColonyByOwner(event.getEntity().f_19853_, event.getEntity());
        }
        ClientEventHandler.handleCrafterRecipeTooltips(colony, event.getToolTip(), event.getItemStack().m_41720_());
        if (event.getItemStack().m_41720_() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)event.getItemStack().m_41720_();
            if (blockItem.m_40614_() instanceof AbstractBlockHut) {
                ClientEventHandler.handleHutBlockResearchUnlocks(colony, event.getToolTip(), blockItem.m_40614_());
            }
            if (event.getEntity().m_7500_() && InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((Container)event.getEntity().m_150109_()), (Item)ModItems.scanTool.get())) {
                int tier = SchemAnalyzerUtil.getBlockTier(blockItem.m_40614_());
                if (DomumOrnamentumUtils.isDoBlock(blockItem.m_40614_()) && event.getItemStack().m_41782_()) {
                    for (Block block : DomumOrnamentumUtils.getTextureData(event.getItemStack()).getTexturedComponents().values()) {
                        tier = Math.max(tier, SchemAnalyzerUtil.getBlockTier(block));
                    }
                }
                event.getToolTip().add(Component.m_237110_((String)"com.minecolonies.coremod.tooltip.schematic.tier", (Object[])new Object[]{tier}));
            }
        }
    }

    private static void handleCrafterRecipeTooltips(@Nullable IColony colony, List<Component> toolTip, Item item) {
        List<CustomRecipe> recipes = CustomRecipeManager.getInstance().getRecipeByOutput(item);
        if (recipes.isEmpty()) {
            return;
        }
        HashMap<BuildingEntry, Integer> minimumBuildingLevels = new HashMap<BuildingEntry, Integer>();
        for (CustomRecipe customRecipe : recipes) {
            BuildingEntry craftingBuilding;
            if (!customRecipe.getShowTooltip() || customRecipe.getCrafter().length() < 2 || (craftingBuilding = (BuildingEntry)((Map)crafterToBuilding.get()).get(customRecipe.getCrafter())) == null) continue;
            minimumBuildingLevels.putIfAbsent(craftingBuilding, null);
            if (minimumBuildingLevels.get(craftingBuilding) == null || customRecipe.getMinBuildingLevel() < (Integer)minimumBuildingLevels.get(craftingBuilding)) {
                minimumBuildingLevels.put(craftingBuilding, customRecipe.getMinBuildingLevel());
            }
            for (ResourceLocation id : customRecipe.getRequiredResearchIds()) {
                Set<Object> researches;
                if (IMinecoloniesAPI.getInstance().getGlobalResearchTree().hasResearch(id)) {
                    researches = new HashSet<IGlobalResearch>();
                    researches.add(IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearch(id));
                } else {
                    researches = IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearchForEffect(id);
                }
                if (researches == null) continue;
                ChatFormatting researchFormat = colony != null && (colony.getResearchManager().getResearchTree().hasCompletedResearch(id) || colony.getResearchManager().getResearchEffects().getEffectStrength(id) > 0.0) ? ChatFormatting.AQUA : ChatFormatting.RED;
                for (IGlobalResearch iGlobalResearch : researches) {
                    toolTip.add((Component)Component.m_237110_((String)"com.minecolonies.coremod.item.requiresresearch.gui", (Object[])new Object[]{MutableComponent.m_237204_((ComponentContents)iGlobalResearch.getName())}).m_6270_(Style.f_131099_.m_131140_(researchFormat)));
                }
            }
        }
        for (Map.Entry entry : minimumBuildingLevels.entrySet()) {
            Component craftingBuildingName = ClientEventHandler.getFullBuildingName((BuildingEntry)entry.getKey());
            Integer minimumLevel = (Integer)entry.getValue();
            if (minimumLevel > 0) {
                String schematicName = ((BuildingEntry)entry.getKey()).getRegistryName().m_135815_();
                MutableComponent reqLevelText = Component.m_237110_((String)"com.minecolonies.coremod.item.buildlevel.gui", (Object[])new Object[]{craftingBuildingName, minimumLevel});
                if (colony != null && colony.hasBuilding(schematicName, minimumLevel, true)) {
                    reqLevelText.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA));
                } else {
                    reqLevelText.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                }
                toolTip.add((Component)reqLevelText);
                continue;
            }
            MutableComponent reqBuildingTxt = Component.m_237110_((String)"com.minecolonies.coremod.item.available.gui", (Object[])new Object[]{craftingBuildingName}).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY));
            toolTip.add((Component)reqBuildingTxt);
        }
    }

    private static Component getFullBuildingName(@NotNull BuildingEntry building) {
        String namespace = building.getBuildingBlock().getRegistryName().m_135827_();
        String modName = ModList.get().getModContainerById(namespace).map(m -> m.getModInfo().getDisplayName()).orElse(namespace);
        MutableComponent buildingName = building.getBuildingBlock().m_49954_();
        return Component.m_237113_((String)(modName + " ")).m_7220_((Component)buildingName);
    }

    private static Map<String, BuildingEntry> buildCrafterToBuildingMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            for (BuildingEntry.ModuleProducer moduleProducer : building.getModuleProducers()) {
                ICraftingBuildingModule craftingBuildingModule;
                IBuildingModule module = BuildingEntry.produceModuleWithoutBuilding(moduleProducer.key);
                if (!(module instanceof ICraftingBuildingModule) || (craftingBuildingModule = (ICraftingBuildingModule)module).getCraftingJob() == null) continue;
                builder.put((Object)craftingBuildingModule.getCustomRecipeKey(), (Object)building);
            }
        }
        return builder.build();
    }

    private static void handleHutBlockResearchUnlocks(IColony colony, List<Component> tooltip, Block block) {
        if (colony == null) {
            return;
        }
        ResourceLocation effectId = colony.getResearchManager().getResearchEffectIdFrom(block);
        if (colony.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            tooltip.add((Component)Component.m_237110_((String)"com.minecolonies.coremod.research.item1", (Object[])new Object[]{block.m_49954_()}));
            tooltip.add((Component)Component.m_237110_((String)"com.minecolonies.coremod.research.item2", (Object[])new Object[]{block.m_49954_()}));
        }
    }

    @SubscribeEvent
    public static void onDebugOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            ClientLevel world = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            BlockPos pos = player.m_20183_();
            IColony colony = IColonyManager.getInstance().getIColony((Level)world, pos);
            if (colony == null) {
                if (IColonyManager.getInstance().isFarEnoughFromColonies((Level)world, pos)) {
                    event.getLeft().add(Component.m_237115_((String)"com.minecolonies.coremod.gui.debugscreen.noclosecolony").getString());
                    return;
                }
                colony = IColonyManager.getInstance().getClosestIColony((Level)world, pos);
                if (colony == null) {
                    return;
                }
                event.getLeft().add(Component.m_237110_((String)"com.minecolonies.coremod.gui.debugscreen.nextcolony", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos)), IColonyManager.getInstance().getMinimumDistanceBetweenTownHalls()}).getString());
                return;
            }
            event.getLeft().add(colony.getName() + " : " + Component.m_237110_((String)"com.minecolonies.coremod.gui.debugscreen.blocksfromcenter", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos))}).getString());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Item item;
        if (!event.getLevel().m_5776_()) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && (item = event.getItemStack().m_41720_()) instanceof BlockItem) {
            IBuildingBrowsableBlock browsable;
            BlockItem blockItem = (BlockItem)item;
            if (Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91077_.m_6662_() != HitResult.Type.MISS) {
                return;
            }
            Block block = blockItem.m_40614_();
            if (block instanceof IBuildingBrowsableBlock && (browsable = (IBuildingBrowsableBlock)block).shouldBrowseBuildings(event)) {
                MinecoloniesAPIProxy.getInstance().getBuildingDataManager().openBuildingBrowser(block);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

