/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PathJobMoveToWithPassable
extends PathJobMoveToLocation {
    public static final double PASSING_COST = 3.0;
    private Function<BlockState, Boolean> isPassable;

    public PathJobMoveToWithPassable(Level world, @NotNull BlockPos start, @NotNull BlockPos end, int range, Mob entity, Function<BlockState, Boolean> isPassable) {
        super(world, start, end, range, entity);
        this.isPassable = isPassable;
    }

    @Override
    protected boolean isPassable(@NotNull BlockState block, int x, int y, int z, MNode parent, boolean head) {
        return super.isPassable(block, x, y, z, parent, head) || this.isPassable.apply(block) != false;
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state) {
        if (!state.m_60795_() && this.isPassable.apply(state).booleanValue()) {
            return cost * 3.0;
        }
        BlockState above = this.cachedBlockLookup.getBlockState(x, y + 1, z);
        if (!above.m_60795_() && this.isPassable.apply(above).booleanValue()) {
            return cost * 3.0;
        }
        return cost;
    }
}

