/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PathJobMoveCloseToXNearY
extends AbstractPathJob {
    protected final BlockPos desiredPosition;
    protected final BlockPos nearbyPosition;
    protected final int distToDesired;

    public PathJobMoveCloseToXNearY(Level world, BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, Mob entity) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)entity), desiredPosition, new PathResult(), entity);
        this.desiredPosition = desiredPosition;
        this.nearbyPosition = nearbyPosition;
        this.distToDesired = distToDesired;
        this.extraNodes = 20;
        this.maxNodes /= 2;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.desiredPosition, x, y, z) * 2 + BlockPosUtil.distManhattan(this.nearbyPosition, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.desiredPosition, n.x, n.y, n.z) < this.distToDesired && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.desiredPosition, n.x, n.y, n.z) * 2 + BlockPosUtil.distManhattan(this.nearbyPosition, n.x, n.y, n.z);
    }

    @Override
    protected boolean stopOnNodeLimit(int totalNodesVisited, MNode bestNode, int nodesSinceEndNode) {
        if (nodesSinceEndNode > 200) {
            return true;
        }
        this.maxNodes += 200;
        return false;
    }
}

