/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.WaterPathResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob {
    private static final int MIN_DISTANCE = 40;
    private static final int MAX_RANGE = 100;
    private final BlockPos hutLocation;
    @NotNull
    private final ArrayList<Tuple<BlockPos, BlockPos>> ponds;

    public PathJobFindWater(Level world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<Tuple<BlockPos, BlockPos>> ponds, Mob entity) {
        super(world, start, range, (PathResult)new WaterPathResult(), entity);
        this.ponds = new ArrayList<Tuple<BlockPos, BlockPos>>(ponds);
        this.hutLocation = home;
        this.getPathingOptions().swimCostEnter = 0.0;
        this.getPathingOptions().swimCost = 0.2;
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.hutLocation, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (BlockPosUtil.distSqr(this.hutLocation, n.x, n.y, n.z) > 10000) {
            return false;
        }
        if (this.isNearWater(n)) {
            this.getResult().parent = new BlockPos(n.x, n.y, n.z);
            this.getResult().isEmpty = this.ponds.isEmpty();
            return SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
        }
        return false;
    }

    private boolean isNearWater(@NotNull MNode n) {
        if (n.parent == null) {
            return false;
        }
        if (this.cachedBlockLookup.getBlockState(n.x, n.y, n.z).m_60734_() != Blocks.f_49990_ && this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z).m_60734_() != Blocks.f_49990_) {
            if (n.x == n.parent.x) {
                int dz = n.z > n.parent.z ? 1 : -1;
                return Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z + dz), this.getResult()) || Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x - 1, n.y - 1, n.z), this.getResult()) || Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x + 1, n.y - 1, n.z), this.getResult());
            }
            int dx = n.x > n.parent.x ? 1 : -1;
            return Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x + dx, n.y - 1, n.z), this.getResult()) || Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z - 1), this.getResult()) || Pond.checkWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z + 1), this.getResult());
        }
        return this.getResult().pond != null && !this.ponds.contains(new Tuple<BlockPos, BlockPos>(new BlockPos(n.x, n.y, n.z), new BlockPos(n.parent.x, n.parent.y, n.parent.z))) && !PathJobFindWater.pondsAreNear(this.ponds, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z));
    }

    private static boolean pondsAreNear(@NotNull ArrayList<Tuple<BlockPos, BlockPos>> ponds, @NotNull BlockPos newPond) {
        if (ponds.isEmpty()) {
            return false;
        }
        for (Tuple<BlockPos, BlockPos> p : ponds) {
            if (BlockPosUtil.distSqr(p.getB(), newPond) >= 1600) continue;
            return true;
        }
        return false;
    }
}

