/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.mobs.drownedpirate.AbstractDrownedEntityPirate;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.core.Network;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.network.messages.client.SyncPathReachedMessage;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfindingUtils {
    private static Object empty = Fluids.f_76191_.m_76145_();
    public static final Map<UUID, UUID> trackingMap = new ConcurrentHashMap<UUID, UUID>();

    public static void syncDebugReachedPositions(HashSet<BlockPos> reached, Mob mob) {
        if (reached.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, UUID> entry : trackingMap.entrySet()) {
            ServerPlayer player;
            if (!entry.getValue().equals(mob.m_20148_()) || (player = mob.f_19853_.m_7654_().m_6846_().m_11259_(entry.getKey())) == null) continue;
            Network.getNetwork().sendToPlayer(new SyncPathReachedMessage(reached), player);
        }
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)entity.m_20186_()), Mth.m_14107_((double)entity.m_20189_()));
        Level level = entity.f_19853_;
        BlockState bs = level.m_8055_((BlockPos)pos);
        VoxelShape collisionShape = bs.m_60812_((BlockGetter)level, (BlockPos)pos);
        boolean isFineToStandIn = PathfindingUtils.canStandInSolidBlock(bs);
        if (bs.m_280555_() && !isFineToStandIn && collisionShape.m_83297_(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.m_20185_() % 1.0);
            double relPosZ = Math.abs(entity.m_20189_() % 1.0);
            for (AABB box : collisionShape.m_83299_()) {
                if (!(relPosX >= box.f_82288_) || !(relPosX <= box.f_82291_) || !(relPosZ >= box.f_82290_) || !(relPosZ <= box.f_82293_) || !(box.f_82292_ > 0.0)) continue;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
                break;
            }
        }
        BlockState down = level.m_8055_(pos.m_7495_());
        while (PathfindingUtils.canStandInSolidBlock(bs) && PathfindingUtils.canStandInSolidBlock(down) && !down.m_60734_().isLadder(down, (LevelReader)level, pos.m_7495_(), entity) && down.m_60819_().m_76178_()) {
            pos.m_122175_(Direction.DOWN, 1);
            bs = down;
            down = level.m_8055_(pos.m_7495_());
            if (pos.m_123342_() >= entity.m_20193_().m_141937_()) continue;
            return entity.m_20183_();
        }
        Block b = bs.m_60734_();
        if (entity.m_20069_() && !(entity instanceof AbstractDrownedEntityPirate)) {
            while (!bs.m_60819_().m_76178_()) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.m_280555_() && !PathfindingUtils.canStandInSolidBlock(bs)) {
            VoxelShape shape = bs.m_60812_((BlockGetter)level, (BlockPos)pos);
            if (shape.m_83281_()) {
                return pos.m_7949_();
            }
            Vec3 relativePos = entity.m_20182_().m_82546_(shape.m_83216_((double)entity.m_146903_(), (double)entity.m_146904_(), (double)entity.m_146907_()).m_83215_().m_82399_());
            double dX = relativePos.f_82479_;
            double dZ = relativePos.f_82481_;
            if (Math.abs(dX) < Math.abs(dZ)) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_(), dZ < 0.0 ? pos.m_123343_() - 1 : pos.m_123343_() + 1);
            } else {
                pos.m_122178_(dX < 0.0 ? pos.m_123341_() - 1 : pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
        }
        return pos.m_7949_();
    }

    private static boolean canStandInSolidBlock(BlockState state) {
        return state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof TrapDoorBlock || state.m_60734_() instanceof PanelBlock && (Boolean)state.m_61143_((Property)PanelBlock.OPEN) != false || !state.m_60734_().f_60439_.f_60884_;
    }

    public static void setLadderFacing(@NotNull LevelReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof VineBlock) {
            if (((Boolean)state.m_61143_((Property)VineBlock.f_57836_)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57837_)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57834_)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57835_)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.m_61143_((Property)LadderBlock.f_54337_));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    public static boolean isLiquid(BlockState state) {
        return state.m_278721_() || !state.m_280555_() && !state.m_60819_().m_76178_();
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos) {
        return PathfindingUtils.isWater(world, pos, null, null);
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_60815_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.m_6425_(pos);
        }
        if (fluidState == empty || fluidState.m_76178_()) {
            return false;
        }
        if (state.m_60734_() instanceof TrapdoorBlock || state.m_60734_() instanceof PanelBlock && !((Boolean)state.m_61143_((Property)TrapdoorBlock.f_57514_)).booleanValue() && state.m_61143_((Property)TrapdoorBlock.f_57515_) == Half.TOP) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_;
    }

    public static boolean isLava(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_60734_() == Blocks.f_49991_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.m_6425_(pos);
        }
        if (fluidState == empty || fluidState.m_76178_()) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76195_ || fluid == Fluids.f_76194_;
    }

    public static boolean isLadder(BlockState blockState, @Nullable PathingOptions options) {
        if (options != null && options.canWalkUnderWater() && PathfindingUtils.isLiquid(blockState)) {
            return true;
        }
        return blockState.m_204336_(BlockTags.f_13082_) && (options != null && options.canClimbAdvanced() || blockState.m_60734_() instanceof LadderBlock || blockState.m_204336_(ModTags.freeClimbBlocks));
    }

    public static boolean isDangerous(BlockState blockState) {
        Block block = blockState.m_60734_();
        return blockState.m_204336_(ModTags.dangerousBlocks) || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof MagmaBlock || block instanceof SweetBerryBushBlock || block instanceof PowderSnowBlock;
    }
}

