/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.core.colony.jobs.JobShepherd;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkShepherd
extends AbstractEntityAIHerder<JobShepherd, BuildingShepherd> {
    private static final int HUNDRED_PERCENT_CHANCE = 100;

    public EntityAIWorkShepherd(@NotNull JobShepherd job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.SHEPHERD_SHEAR, this::shearSheep, 20));
    }

    @Override
    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        List<ToolType> toolsNeeded = super.getExtraToolsNeeded();
        if (((BuildingShepherd)this.building).getSetting(BuildingShepherd.SHEARING).getValue().booleanValue()) {
            toolsNeeded.add(ToolType.SHEARS);
        }
        return toolsNeeded;
    }

    @Override
    public Class<BuildingShepherd> getExpectedBuildingClass() {
        return BuildingShepherd.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        Sheep shearingSheep = this.findShearableSheep();
        if (((BuildingShepherd)this.building).getSetting(BuildingShepherd.SHEARING).getValue().booleanValue() && result.equals(AIWorkerState.START_WORKING) && shearingSheep != null) {
            return AIWorkerState.SHEPHERD_SHEAR;
        }
        this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        return result;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getSecondarySkillLevel() / 10.0);
    }

    @Nullable
    private Sheep findShearableSheep() {
        return this.searchForAnimals(a -> {
            Sheep sheepie;
            return a instanceof Sheep && !(sheepie = (Sheep)a).m_29875_() && !sheepie.m_6162_();
        }).stream().map(a -> (Sheep)a).findAny().orElse(null);
    }

    private IAIState shearSheep() {
        Sheep sheep = this.findShearableSheep();
        if (sheep == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(InteractionHand.MAIN_HAND, ToolType.SHEARS)) {
            return AIWorkerState.PREPARING;
        }
        if (this.worker.m_21205_() != null) {
            if (this.walkingToAnimal((Animal)sheep)) {
                return this.getState();
            }
            int enchantmentLevel = this.worker.m_21205_().getEnchantmentLevel(Enchantments.f_44987_);
            enchantmentLevel = (int)((double)enchantmentLevel * Math.max(1.0, (double)this.getPrimarySkillLevel() / 5.0));
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (!this.world.f_46443_) {
                sheep.m_29878_(true);
                int qty = 1 + this.worker.m_217043_().m_188503_(enchantmentLevel + 1);
                for (int j = 0; j < qty; ++j) {
                    items.add(new ItemStack((ItemLike)Sheep.f_29800_.get(sheep.m_29874_())));
                }
            }
            sheep.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(new ItemStack((ItemLike)Sheep.f_29800_.get(sheep.m_29874_())), sheep.m_20097_().m_7494_()), (Entity)this.worker);
            this.dyeSheepChance(sheep);
            this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
            for (ItemStack item : items) {
                ((BuildingShepherd)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + item.m_41720_().m_5524_(), item.m_41613_());
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        return AIWorkerState.DECIDE;
    }

    private void dyeSheepChance(Sheep sheep) {
        if (this.building != null && ((BuildingShepherd)this.building).getSetting(BuildingShepherd.DYEING).getValue().booleanValue()) {
            int chanceToDye = ((BuildingShepherd)this.building).getBuildingLevel();
            int rand = this.worker.m_217043_().m_188503_(100);
            if (rand <= chanceToDye) {
                DyeColor[] colors = DyeColor.values();
                int dyeIndex = this.worker.m_217043_().m_188503_(colors.length);
                sheep.m_29855_(colors[dyeIndex]);
            }
        }
    }
}

