/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFlorist;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.tileentities.TileEntityCompostedDirt;
import com.minecolonies.core.util.WorkerUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFlorist
extends AbstractEntityAIInteract<JobFlorist, BuildingFlorist> {
    private static final long MAX_DISTANCE = 50L;
    private static final int HARVEST_ACTIONS_TO_DUMP = 10;
    private static final double PERCENT_CHANGE_FOR_GROWTH = 0.2;
    private static final double BASE_XP_GAIN = 0.5;
    private static final int COMPOST_REQUEST_QTY = 16;
    private static final int BASE_BLOCK_MINING_DELAY = 10;
    private static final double PER_LEVEL_BONUS = 0.1;
    private static final double MAX_BONUS = 5.0;
    private static final VisibleCitizenStatus GARDENING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/florist.png"), "com.minecolonies.gui.visiblestatus.florist");
    private static final double XP_PER_FLOWER = 2.0;
    public static final String RENDER_META_FLOWERS = "flowers";
    private BlockPos harvestPosition;
    private BlockPos compostPosition;

    public EntityAIWorkFlorist(@NotNull JobFlorist job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<AIWorkerState>(AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 200), new AITarget<Object>(AIWorkerState.FLORIST_HARVEST, this::harvest, 20), new AITarget<Object>(AIWorkerState.FLORIST_COMPOST, this::compost, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata((InventoryUtils.hasItemInItemHandler(this.worker.getItemHandlerCitizen(), stack -> stack.m_204117_(ItemTags.f_13149_)) ? RENDER_META_FLOWERS : "") + (this.getState() == AIWorkerState.IDLE ? "" : "working"));
    }

    private IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((BuildingFlorist)this.building).getPlantGround().isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.noplantground"), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        long distance = BlockPosUtil.getDistance2D(this.worker.m_20183_(), ((BuildingFlorist)this.building).getPosition());
        if (distance > 50L && this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST);
        if (amountOfCompostInInv <= 0) {
            int amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, ItemStackUtils.IS_COMPOST, 1);
            if (amountOfCompostInBuilding > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ItemStackUtils.IS_COMPOST, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)ModItems.compost, 16));
        }
        this.harvestPosition = this.areThereFlowersToGather();
        if (this.harvestPosition != null) {
            return AIWorkerState.FLORIST_HARVEST;
        }
        if (amountOfCompostInInv <= 0) {
            if (!WorkerUtil.isThereCompostedLand((BuildingFlorist)this.building, this.world)) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.nocompost"), ChatPriority.BLOCKING));
                return AIWorkerState.START_WORKING;
            }
            return AIWorkerState.DECIDE;
        }
        this.compostPosition = this.getFirstNotCompostedLand();
        return AIWorkerState.FLORIST_COMPOST;
    }

    private IAIState compost() {
        if (this.compostPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (this.walkToBlock(this.compostPosition)) {
            return this.getState();
        }
        BlockEntity entity = this.world.m_7702_(this.compostPosition);
        if (entity instanceof TileEntityCompostedDirt) {
            @Nullable ItemStack stack = ((BuildingFlorist)this.building).getFlowerToGrow();
            if (stack != null) {
                if (this.worker.m_217043_().m_188503_(200 - this.getPrimarySkillLevel()) < 0 || InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST)) {
                    ((TileEntityCompostedDirt)entity).compost(0.2 - (double)((BuildingFlorist)this.building).getBuildingLevel() * 0.01, ((BuildingFlorist)this.building).getFlowerToGrow());
                }
            } else {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.noflowers"), ChatPriority.BLOCKING));
            }
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.compostPosition = null;
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvest() {
        if (this.harvestPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (this.walkToBlock(this.harvestPosition)) {
            return this.getState();
        }
        if (!this.mineBlock(this.harvestPosition)) {
            return this.getState();
        }
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.harvestPosition = null;
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10 * ((BuildingFlorist)this.building).getBuildingLevel();
    }

    @Override
    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        return 10 * (int)(1.0 + Math.max(0.0, 5.0 - 0.1 * ((double)this.getSecondarySkillLevel() / 2.0)));
    }

    @Nullable
    private BlockPos areThereFlowersToGather() {
        for (BlockPos pos : ((BuildingFlorist)this.building).getPlantGround()) {
            if (this.world.m_46859_(pos.m_7494_())) continue;
            return pos.m_7494_();
        }
        return null;
    }

    private BlockPos getFirstNotCompostedLand() {
        for (BlockPos pos : ((BuildingFlorist)this.building).getPlantGround()) {
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.world, pos)) continue;
            BlockEntity entity = this.world.m_7702_(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (((TileEntityCompostedDirt)entity).isComposted()) continue;
                return pos;
            }
            ((BuildingFlorist)this.building).removePlantableGround(pos);
        }
        return null;
    }

    @Override
    public Class<BuildingFlorist> getExpectedBuildingClass() {
        return BuildingFlorist.class;
    }
}

