/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard.training;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAITraining<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    private static final int TARGET_SEARCH_CHANCE = 30;
    protected static final int ONE_HUNDRED_PERCENT = 100;
    protected BlockPos currentPathingTarget;
    protected IAIState stateAfterPathing;
    protected int currentAttackDelay = 0;

    public AbstractEntityAITraining(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, () -> AIWorkerState.DECIDE, 1), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.TRAINING_WANDER, this::wander, 200), new AITarget<Object>(AIWorkerState.GO_TO_TARGET, this::pathToTarget, 20));
        this.worker.m_21553_(true);
    }

    public IAIState decide() {
        if (!this.isSetup()) {
            return AIWorkerState.DECIDE;
        }
        if (this.worker.m_217043_().m_188503_(100) < 30) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.TRAINING_WANDER;
    }

    protected abstract boolean isSetup();

    private IAIState wander() {
        if (this.currentPathingTarget == null) {
            this.currentPathingTarget = this.getWanderPosition();
            return this.getState();
        }
        if (!this.walkToBlock(this.currentPathingTarget)) {
            this.currentPathingTarget = null;
            return AIWorkerState.DECIDE;
        }
        return AIWorkerState.TRAINING_WANDER;
    }

    private IAIState pathToTarget() {
        if (this.walkToBlock(this.currentPathingTarget, 2)) {
            return this.getState();
        }
        return this.stateAfterPathing;
    }

    private BlockPos getWanderPosition() {
        BlockPos pos = this.findRandomPositionToWalkTo(20);
        if (pos == null) {
            return null;
        }
        if (this.building.isInBuilding(pos)) {
            return pos;
        }
        return this.building.getPosition();
    }

    protected void reduceAttackDelay() {
        if (this.currentAttackDelay > 0) {
            --this.currentAttackDelay;
        }
    }
}

