/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.education;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.core.colony.jobs.JobPupil;
import com.minecolonies.core.colony.jobs.JobTeacher;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.other.SittingEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkTeacher
extends AbstractEntityAIInteract<JobTeacher, BuildingSchool> {
    private static final int PAPER_TO_REQUEST = 16;
    private final Predicate<ItemStack> PAPER = stack -> stack.m_41720_() == Items.f_42516_;
    private static final VisibleCitizenStatus TEACHING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/teacher_student.png"), "com.minecolonies.gui.visiblestatus.teacher_student");
    private AbstractEntityCitizen pupilToTeach;
    private int maxSittingTicks = 0;
    private int sittingTicks = 0;

    public EntityAIWorkTeacher(@NotNull JobTeacher job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.TEACH, this::teach, 20));
        this.worker.m_21553_(true);
    }

    private IAIState decide() {
        int paperInInv;
        int paperInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, this.PAPER, 1);
        if (paperInBuilding + (paperInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) <= 0) {
            this.requestPaper();
        }
        if (paperInInv == 0 && paperInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this.PAPER, 16);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        List<AbstractEntityCitizen> pupils = WorldUtil.getEntitiesWithinBuilding(this.world, AbstractEntityCitizen.class, this.building, cit -> cit.m_6162_() && cit.f_19824_ != null && cit.getCitizenJobHandler().getColonyJob() instanceof JobPupil);
        if (pupils.size() > 0) {
            this.pupilToTeach = pupils.get(this.worker.m_217043_().m_188503_(pupils.size()));
            return AIWorkerState.TEACH;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState teach() {
        if (this.pupilToTeach == null || this.pupilToTeach.f_19824_ == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(TEACHING_ICON);
        if (this.walkToBlock(this.pupilToTeach.m_20183_())) {
            return this.getState();
        }
        if (this.maxSittingTicks == 0 || this.worker.f_19824_ == null) {
            int jobModifier = (int)(100.0 / Math.max(1.0, (double)this.getSecondarySkillLevel() / 2.0));
            this.maxSittingTicks = this.worker.m_217043_().m_188503_(jobModifier / 2) + jobModifier / 2;
            SittingEntity.sitDown(this.worker.m_20183_(), (Mob)this.worker, this.maxSittingTicks * 20);
        }
        ++this.sittingTicks;
        if (this.sittingTicks < this.maxSittingTicks) {
            return this.getState();
        }
        if (this.worker.f_19824_ != null) {
            this.worker.m_8127_();
            this.worker.m_6034_(this.worker.m_20185_(), this.worker.m_20186_() + 1.0, this.worker.m_20189_());
        }
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER);
        int pupilSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.pupilToTeach.getInventoryCitizen(), this.PAPER);
        if (slot != -1 && pupilSlot == -1) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER, 1, (IItemHandler)this.pupilToTeach.getInventoryCitizen());
        }
        double xp = 1.5 * (1.0 + (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Intelligence) / 10.0);
        xp *= 1.0 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TEACHING);
        this.pupilToTeach.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, xp *= 1.0 + (double)this.getPrimarySkillLevel() / 10.0, this.pupilToTeach.getCitizenData());
        this.worker.getCitizenExperienceHandler().addExperience(0.1);
        this.worker.decreaseSaturationForContinuousAction();
        this.incrementActionsDone();
        this.maxSittingTicks = 0;
        this.sittingTicks = 0;
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 50;
    }

    private void requestPaper() {
        if (!((BuildingSchool)this.building).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().m_41720_() == Items.f_42516_)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)Items.f_42516_, 16)));
        }
    }

    @Override
    public Class<BuildingSchool> getExpectedBuildingClass() {
        return BuildingSchool.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.DECIDE;
    }
}

