/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.research.GlobalResearch;
import com.minecolonies.core.research.GlobalResearchBranch;
import com.minecolonies.core.research.ResearchEffectCategory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ResearchListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String RESEARCH_REMOVE_PROP = "remove";

    public ResearchListener() {
        super(GSON, "researches");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManagerIn, @NotNull ProfilerFiller profilerIn) {
        Log.getLogger().info("Beginning load of research for University.");
        Map<ResourceLocation, ResearchEffectCategory> effectCategories = this.parseResearchEffects(object);
        Tuple<Collection<ResourceLocation>, Collection<ResourceLocation>> removeResearchesAndBranches = this.parseRemoveResearches(object);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Map<ResourceLocation, GlobalResearch> researchMap = this.parseResearches(object, effectCategories, removeResearchesAndBranches.getA(), removeResearchesAndBranches.getB(), !(server instanceof DedicatedServer));
        IGlobalResearchTree researchTree = this.calcResearchTree(researchMap);
        this.parseResearchBranches(object, researchTree);
        Log.getLogger().info("Loaded " + researchMap.values().size() + " recipes for " + researchTree.getBranches().size() + " research branches");
    }

    private Map<ResourceLocation, ResearchEffectCategory> parseResearchEffects(Map<ResourceLocation, JsonElement> object) {
        HashMap<ResourceLocation, ResearchEffectCategory> effectCategories = new HashMap<ResourceLocation, ResearchEffectCategory>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            JsonObject effectJson = entry.getValue().getAsJsonObject();
            if (effectJson.has("effect")) {
                ResearchEffectCategory category = effectJson.has("name") && effectJson.get("name").isJsonPrimitive() && effectJson.get("name").getAsJsonPrimitive().isString() && effectJson.has("subtitle") && effectJson.get("subtitle").isJsonPrimitive() && effectJson.get("subtitle").getAsJsonPrimitive().isString() ? new ResearchEffectCategory(entry.getKey().toString(), effectJson.get("name").getAsString(), effectJson.get("subtitle").getAsString()) : (effectJson.has("name") && effectJson.get("name").isJsonPrimitive() && effectJson.get("name").getAsJsonPrimitive().isString() ? new ResearchEffectCategory(entry.getKey().toString(), effectJson.get("name").getAsString()) : (effectJson.has("subtitle") && effectJson.get("subtitle").isJsonPrimitive() && effectJson.get("subtitle").getAsJsonPrimitive().isString() ? new ResearchEffectCategory(entry.getKey().toString(), null, effectJson.get("subtitle").getAsString()) : new ResearchEffectCategory(entry.getKey().toString())));
                if (effectJson.has("levels") && effectJson.get("levels").isJsonArray()) {
                    for (JsonElement levelElement : effectJson.get("levels").getAsJsonArray()) {
                        if (!levelElement.isJsonPrimitive() || !levelElement.getAsJsonPrimitive().isNumber()) continue;
                        category.add(levelElement.getAsNumber().floatValue());
                    }
                } else {
                    category.add(5.0);
                }
                effectCategories.put(category.getId(), category);
                continue;
            }
            if (!effectJson.has("effect")) continue;
            Log.getLogger().error(entry.getKey() + " is a research effect, but does not contain all required fields.  Research Effects must have effect: and id:string fields.");
        }
        return effectCategories;
    }

    private Map<ResourceLocation, GlobalResearch> parseResearches(Map<ResourceLocation, JsonElement> object, Map<ResourceLocation, ResearchEffectCategory> effectCategories, Collection<ResourceLocation> removeResearches, Collection<ResourceLocation> removeBranches, boolean checkResourceLoc) {
        HashMap<ResourceLocation, GlobalResearch> researchMap = new HashMap<ResourceLocation, GlobalResearch>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            if (removeResearches.contains(entry.getKey())) {
                if (!((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) continue;
                Log.getLogger().info(entry.getKey() + " was removed by data pack.");
                continue;
            }
            JsonObject researchJson = entry.getValue().getAsJsonObject();
            if (researchJson.has("effect") || researchJson.has(RESEARCH_REMOVE_PROP) && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isString() || researchJson.has("branch-name") || researchJson.has("base-time") || researchJson.has("branch-type")) continue;
            if (!(researchJson.has("branch") && researchJson.get("branch").isJsonPrimitive() && researchJson.get("branch").getAsJsonPrimitive().isString())) {
                if (!((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) continue;
                Log.getLogger().warn(entry.getKey() + " is a Research , but does not contain all required fields.  Researches must have a branch:string properties.");
                continue;
            }
            if (removeBranches.contains(new ResourceLocation(researchJson.get("branch").getAsString()))) {
                if (!((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) continue;
                Log.getLogger().info(entry.getKey() + " was removed, as its branch had been removed by data pack.");
                continue;
            }
            if (!researchJson.has("researchLevel") || !researchJson.get("researchLevel").getAsJsonPrimitive().isNumber()) {
                Log.getLogger().debug(entry.getKey() + " is a Research, but has invalid or no university level requirements.");
            }
            GlobalResearch research = new GlobalResearch(researchJson, entry.getKey(), effectCategories, checkResourceLoc);
            Log.getLogger().debug("Parsed research recipe from " + entry.getKey() + " [" + research.getBranch() + "/" + research.getId() + "]");
            Log.getLogger().debug(research.getName() + " at " + research.getDepth() + "/" + research.getParent());
            for (IResearchRequirement iResearchRequirement : research.getResearchRequirement()) {
                Log.getLogger().debug("Requirement: " + iResearchRequirement.getDesc());
            }
            for (IResearchCost iResearchCost : research.getCostList()) {
                Log.getLogger().debug("Cost: " + iResearchCost.toString());
            }
            for (IResearchEffect iResearchEffect : research.getEffects()) {
                Log.getLogger().debug("Effect: " + iResearchEffect.getId() + " " + iResearchEffect.getDesc());
            }
            researchMap.put(research.getId(), research);
        }
        return researchMap;
    }

    private Tuple<Collection<ResourceLocation>, Collection<ResourceLocation>> parseRemoveResearches(Map<ResourceLocation, JsonElement> object) {
        HashSet<ResourceLocation> removeResearches = new HashSet<ResourceLocation>();
        HashSet<ResourceLocation> removeBranches = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            JsonObject researchJson = entry.getValue().getAsJsonObject();
            if (!researchJson.has(RESEARCH_REMOVE_PROP)) continue;
            if (researchJson.has("branch-name") || researchJson.has("base-time")) {
                if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonArray()) {
                    for (JsonElement remove : researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonArray()) {
                        if (!remove.isJsonPrimitive() || !remove.getAsJsonPrimitive().isString()) continue;
                        removeBranches.add(new ResourceLocation(remove.getAsString()));
                    }
                    continue;
                }
                if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isString()) {
                    removeBranches.add(new ResourceLocation(researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().getAsString()));
                    continue;
                }
                if (!researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() || !researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isBoolean() || !researchJson.get(RESEARCH_REMOVE_PROP).getAsBoolean()) continue;
                removeBranches.add(entry.getKey());
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonArray()) {
                for (JsonElement remove : researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonArray()) {
                    if (!remove.isJsonPrimitive() || !remove.getAsJsonPrimitive().isString()) continue;
                    removeResearches.add(new ResourceLocation(remove.getAsString()));
                }
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isString()) {
                removeResearches.add(new ResourceLocation(researchJson.get(RESEARCH_REMOVE_PROP).getAsString()));
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isBoolean() && researchJson.get(RESEARCH_REMOVE_PROP).getAsBoolean()) {
                removeResearches.add(entry.getKey());
                continue;
            }
            Log.getLogger().error(entry.getKey() + " is a research remove, but does not contain all required fields.  Research Removes must have remove:boolean and id:string.");
        }
        return new Tuple<Collection<ResourceLocation>, Collection<ResourceLocation>>(removeResearches, removeBranches);
    }

    private IGlobalResearchTree calcResearchTree(Map<ResourceLocation, GlobalResearch> researchMap) {
        IGlobalResearchTree researchTree = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree();
        researchTree.reset();
        for (Map.Entry<ResourceLocation, GlobalResearch> entry : researchMap.entrySet()) {
            if (entry.getValue().getParent().m_135815_().isEmpty() && entry.getValue().getDepth() > 1) {
                entry.setValue(new GlobalResearch(entry.getValue().getId(), entry.getValue().getBranch(), 1, entry.getValue().getEffects(), entry.getValue().getIconTextureResourceLocation(), entry.getValue().getIconItemStack(), entry.getValue().isImmutable()));
                Log.getLogger().error(entry.getValue().getBranch() + "/" + entry.getKey() + "could not be attached to tree: inconsistent depth for parentage.");
            } else if (!entry.getValue().getParent().m_135815_().isEmpty()) {
                if (researchMap.containsKey(entry.getValue().getParent())) {
                    if (researchMap.get(entry.getValue().getParent()).getBranch().equals((Object)entry.getValue().getBranch())) {
                        researchMap.get(entry.getValue().getParent()).addChild(entry.getValue());
                    } else {
                        Log.getLogger().error(entry.getValue().getBranch() + "/" + entry.getKey() + "could not be attached to " + entry.getValue().getParent() + " on " + researchMap.get(entry.getValue().getParent()).getBranch());
                        entry.setValue(new GlobalResearch(entry.getValue().getId(), entry.getValue().getBranch(), 1, entry.getValue().getEffects(), entry.getValue().getIconTextureResourceLocation(), entry.getValue().getIconItemStack(), entry.getValue().isImmutable()));
                    }
                } else {
                    Log.getLogger().error(entry.getValue().getBranch() + "/" + entry.getKey() + " could not find parent " + entry.getValue().getParent());
                    entry.setValue(new GlobalResearch(entry.getValue().getId(), entry.getValue().getBranch(), 1, entry.getValue().getEffects(), entry.getValue().getIconTextureResourceLocation(), entry.getValue().getIconItemStack(), entry.getValue().isImmutable()));
                }
            }
            researchTree.addResearch(entry.getValue().getBranch(), entry.getValue(), true);
        }
        return researchTree;
    }

    private void parseResearchBranches(Map<ResourceLocation, JsonElement> object, IGlobalResearchTree researchTree) {
        for (ResourceLocation branchId : researchTree.getBranches()) {
            if (object.containsKey(branchId)) {
                researchTree.addBranchData(branchId, new GlobalResearchBranch(branchId, object.get(branchId).getAsJsonObject()));
                continue;
            }
            researchTree.addBranchData(branchId, new GlobalResearchBranch(branchId));
        }
    }
}

