/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class CitizenNameListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static Map<String, CitizenNameFile> nameFileMap = new HashMap<String, CitizenNameFile>();

    public CitizenNameListener() {
        super(GSON, "citizennames");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        nameFileMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            this.tryParse(entry);
        }
    }

    private void tryParse(Map.Entry<ResourceLocation, JsonElement> entry) {
        try {
            JsonObject data = (JsonObject)entry.getValue();
            int parts = data.get("parts").getAsInt();
            CitizenNameFile.NameOrder nameOrder = CitizenNameFile.NameOrder.valueOf(data.get("order").getAsString());
            ArrayList<String> maleFirstName = new ArrayList<String>();
            ArrayList<String> femaleFirstName = new ArrayList<String>();
            ArrayList<String> surnames = new ArrayList<String>();
            JsonArray maleNameJsonArray = data.get("male_firstname").getAsJsonArray();
            for (Object maleName : maleNameJsonArray) {
                maleFirstName.add(maleName.getAsString());
            }
            JsonArray femaleNameJsonArray = data.get("female_firstname").getAsJsonArray();
            for (JsonElement femaleName : femaleNameJsonArray) {
                femaleFirstName.add(femaleName.getAsString());
            }
            JsonArray surnameJsonArray = data.get("surnames").getAsJsonArray();
            for (JsonElement surname : surnameJsonArray) {
                surnames.add(surname.getAsString());
            }
            nameFileMap.put(entry.getKey().m_135815_(), new CitizenNameFile(parts, nameOrder, maleFirstName, femaleFirstName, surnames));
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not parse visitor for:" + entry.getKey(), (Throwable)e);
        }
    }
}

