/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders.view;

import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWorkOrderView
implements IWorkOrderView {
    private int id;
    private int priority;
    private BlockPos claimedBy;
    private String packName;
    private String structurePath;
    private WorkOrderType workOrderType;
    private BlockPos location;
    private int rotation;
    private boolean isMirrored;
    private int currentLevel;
    private int targetLevel;
    private int amountOfResources;
    private String iteratorType;
    private boolean cleared;
    private boolean requested;
    private String translationKey;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public BlockPos getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public void setClaimedBy(BlockPos position) {
        this.claimedBy = position;
    }

    @Override
    public String getPackName() {
        return this.packName.replaceAll("schematics/(?:decorations/)?", "");
    }

    @Override
    public String getStructurePath() {
        return this.structurePath;
    }

    @Override
    public final String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public WorkOrderType getWorkOrderType() {
        return this.workOrderType;
    }

    @Override
    public BlockPos getLocation() {
        return this.location;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isMirrored() {
        return this.isMirrored;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int getTargetLevel() {
        return this.targetLevel;
    }

    public int getAmountOfResources() {
        return this.amountOfResources;
    }

    public String getIteratorType() {
        return this.iteratorType;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.priority = buf.readInt();
        this.claimedBy = buf.m_130135_();
        this.packName = buf.m_130136_(Short.MAX_VALUE);
        this.structurePath = buf.m_130136_(Short.MAX_VALUE);
        this.translationKey = buf.m_130136_(Short.MAX_VALUE);
        this.workOrderType = WorkOrderType.values()[buf.readInt()];
        this.location = buf.m_130135_();
        this.rotation = buf.readInt();
        this.isMirrored = buf.readBoolean();
        this.currentLevel = buf.readInt();
        this.targetLevel = buf.readInt();
        this.amountOfResources = buf.readInt();
        this.iteratorType = buf.m_130136_(Short.MAX_VALUE);
        this.cleared = buf.readBoolean();
        this.requested = buf.readBoolean();
    }

    @Override
    public boolean canBuildIgnoringDistance(@NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.targetLevel || builderLevel == 5 || builderLocation.equals((Object)this.location);
    }
}

