/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractWarehouseRequestResolver;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WarehouseRequestResolver
extends AbstractWarehouseRequestResolver {
    public WarehouseRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    protected boolean internalCanResolve(List<TileEntityWareHouse> wareHouses, IRequest<? extends IDeliverable> requestToCheck) {
        if (requestToCheck.getRequest() instanceof IConcreteDeliverable) {
            return false;
        }
        for (TileEntityWareHouse wareHouse : wareHouses) {
            if (!wareHouse.hasMatchingItemStackInWarehouse(itemStack -> ((IDeliverable)requestToCheck.getRequest()).matches((ItemStack)itemStack), requestToCheck.getRequest().getMinimumCount())) continue;
            return true;
        }
        return false;
    }
}

