/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.INonExhaustiveDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractWarehouseRequestResolver;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WarehouseConcreteRequestResolver
extends AbstractWarehouseRequestResolver {
    public WarehouseConcreteRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    protected boolean internalCanResolve(List<TileEntityWareHouse> wareHouses, IRequest<? extends IDeliverable> requestToCheck) {
        IDeliverable deliverable = requestToCheck.getRequest();
        if (deliverable instanceof IConcreteDeliverable) {
            boolean ignoreNBT = false;
            boolean ignoreDamage = false;
            if (deliverable instanceof Stack) {
                if (!((Stack)requestToCheck.getRequest()).matchNBT()) {
                    ignoreNBT = true;
                }
                if (!((Stack)requestToCheck.getRequest()).matchDamage()) {
                    ignoreDamage = true;
                }
            }
            for (ItemStack possible : ((IConcreteDeliverable)deliverable).getRequestedItems()) {
                for (TileEntityWareHouse wareHouse : wareHouses) {
                    if (!(requestToCheck.getRequest() instanceof INonExhaustiveDeliverable ? wareHouse.hasMatchingItemStackInWarehouse(possible, requestToCheck.getRequest().getMinimumCount(), ignoreNBT, ignoreDamage, ((INonExhaustiveDeliverable)requestToCheck.getRequest()).getLeftOver()) : wareHouse.hasMatchingItemStackInWarehouse(possible, requestToCheck.getRequest().getMinimumCount(), ignoreNBT, ignoreDamage, 0))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

